/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.scalar;

import java.io.Serializable;
import java.util.Collection;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.catalyst.Mapping;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.SerializableFunction;
import net.e6tech.elements.network.cluster.catalyst.transform.Series;

public class Scalar<Re extends Reactor, T, R, U>
implements Cloneable,
SerializableFunction<Re, U>,
Serializable {
    private static final long serialVersionUID = 1676649613567136786L;
    private Series<Re, T, R> series;
    private Mapping<Re, Collection<R>, U> mapping;

    public Scalar() {
    }

    public Scalar(Mapping<Re, Collection<R>, U> mapping) {
        this.setMapping(mapping);
    }

    @Override
    public U apply(Re reactor) {
        Series<Re, Re, R> t = this.series;
        Collection collection = (Collection)t.apply(reactor);
        Mapping<Re, Collection<R>, Collection> m = this.mapping;
        return (U)m.apply(reactor, collection);
    }

    public Scalar<Re, T, R, U> clone() {
        try {
            return (Scalar)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Scalar<Re, T, R, U> gatherer() {
        return this.clone();
    }

    public Series<Re, T, R> getSeries() {
        return this.series;
    }

    public void setSeries(Series<Re, T, R> series) {
        this.series = series;
    }

    public Mapping<Re, Collection<R>, U> getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping<Re, Collection<R>, U> mapping) {
        this.mapping = mapping;
    }
}

