/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.messaging;

import akka.actor.typed.ActorRef;
import java.io.Serializable;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.messaging.MessagingEvents;
import net.e6tech.elements.network.cluster.messaging.Messenger;

public class Messaging
implements Broadcast {
    private Guardian guardian;
    private ActorRef<MessagingEvents> messenger;
    private String name = "messaging";
    private long timeout = 10000L;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void start(Guardian guardian) {
        this.guardian = guardian;
        this.messenger = guardian.childActor(Messenger.class).withName(this.name).spawn((Receptor)new Messenger());
    }

    public void shutdown() {
        if (this.guardian != null) {
            this.guardian.talk(this.messenger).stop();
        }
    }

    public void subscribe(String topic, Subscriber subscriber) {
        this.guardian.talk(this.messenger).tell((Object)new MessagingEvents.Subscribe(topic, subscriber));
    }

    public void unsubscribe(String topic, Subscriber subscriber) {
        this.guardian.talk(this.messenger).tell((Object)new MessagingEvents.Unsubscribe(topic, subscriber));
    }

    public void publish(Notice<?> notice) {
        this.guardian.talk(this.messenger).tell((Object)new MessagingEvents.Publish(notice.getTopic(), notice.getUserObject()));
    }

    public void destination(String destination, Subscriber subscriber) {
        this.guardian.talk(this.messenger).ask(ref -> new MessagingEvents.NewDestination((ActorRef)ref, destination, subscriber));
    }

    public void send(String destination, Serializable object) {
        this.guardian.talk(this.messenger).tell((Object)new MessagingEvents.Send(destination, object));
    }
}

