/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.Address;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.PostStop;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.Behaviors;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.cluster.typed.Cluster;
import akka.cluster.typed.Subscribe;
import akka.cluster.typed.Unsubscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import net.e6tech.elements.common.actor.GenesisActor;
import net.e6tech.elements.common.actor.typed.Ask;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.federation.Genesis;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.MemberListener;
import net.e6tech.elements.network.cluster.invocation.RegistryActor;
import net.e6tech.elements.network.cluster.messaging.Messaging;

public class ClusterNode
implements Initializable,
Genesis {
    public static final long DEFAULT_TIME_OUT = 10000L;
    private String name;
    private GenesisActor genesis;
    private Membership membership;
    private Messaging broadcast;
    private RegistryActor registry;
    private Class<? extends RegistryActor> registryClass = RegistryActor.class;
    private boolean started = false;
    private long timeout = 10000L;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (this.broadcast != null) {
            this.broadcast.setTimeout(timeout);
        }
        if (this.registry != null) {
            this.registry.setTimeout(timeout);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GenesisActor getGenesis() {
        return this.genesis;
    }

    @Inject(optional=true)
    public void setGenesis(GenesisActor genesis) {
        this.genesis = genesis;
    }

    public Broadcast getBroadcast() {
        return this.broadcast;
    }

    public RegistryActor getRegistry() {
        return this.registry;
    }

    public Map<Address, Member> getMembers() {
        try {
            return this.membership.getExtension().members(new MemberEvents.Members());
        }
        catch (Exception ex) {
            return Collections.emptyMap();
        }
    }

    public List<MemberListener> getListeners() {
        try {
            return this.membership.getExtension().listeners(new MemberEvents.Listeners());
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public void addMemberListener(MemberListener listener) {
        this.membership.talk(MemberEvents.class).tell((Object)new MemberEvents.AddListener(listener));
    }

    public void removeMemberListener(MemberListener listener) {
        this.membership.talk(MemberEvents.class).tell((Object)new MemberEvents.RemoveListener(listener));
    }

    public Class<? extends RegistryActor> getRegistryClass() {
        return this.registryClass;
    }

    public void setRegistryClass(Class<? extends RegistryActor> registryClass) {
        this.registryClass = registryClass;
    }

    public void initialize(Resources resources) {
        if (this.genesis == null) {
            this.genesis = new GenesisActor();
            this.genesis.setName(this.getName());
            this.genesis.setTimeout(this.getTimeout());
            this.genesis.initialize(resources);
        }
        this.initialize(this.genesis);
    }

    public void initialize(GenesisActor genesis) {
        this.genesis = genesis;
        this.setName(genesis.getName());
        this.setTimeout(genesis.getTimeout());
        this.start();
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (this.membership == null) {
            this.membership = (Membership)this.genesis.getGuardian().childActor(Membership.class).spawnNow((Receptor)new Membership());
        }
        if (this.broadcast == null) {
            this.broadcast = new Messaging();
            this.broadcast.setTimeout(this.timeout);
        }
        if (this.registry == null) {
            try {
                this.registry = this.getRegistryClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            this.registry.setTimeout(this.timeout);
        }
        this.broadcast.start(this.genesis.getGuardian());
        this.registry.start(this.genesis.getGuardian());
        this.started = true;
    }

    public void shutdown() {
        this.membership.talk().stop();
        this.broadcast.shutdown();
        this.registry.shutdown();
        this.genesis.terminate();
        this.started = false;
    }

    public CompletionStage<Void> async(Runnable runnable) {
        return this.genesis.async(runnable);
    }

    public <R> CompletionStage<R> async(Supplier<R> callable) {
        return this.genesis.async(callable);
    }

    static interface MemberEvents {

        public static class RemoveListener
        implements MemberEvents {
            MemberListener listener;

            public RemoveListener(MemberListener listener) {
                this.listener = listener;
            }
        }

        public static class AddListener
        implements MemberEvents {
            MemberListener listener;

            public AddListener(MemberListener listener) {
                this.listener = listener;
            }
        }

        public static class Listeners
        extends Ask
        implements MemberEvents {
            public Listeners() {
            }

            public Listeners(ActorRef<List<MemberListener>> sender) {
                this.setSender(sender);
            }
        }

        public static class Members
        extends Ask
        implements MemberEvents {
            public Members() {
            }

            public Members(ActorRef<Map<Address, Member>> sender) {
                this.setSender(sender);
            }
        }
    }

    public static class MembershipExtension
    extends Receptor<MemberEvents, MembershipExtension> {
        private Map<Address, Member> members;
        private List<MemberListener> memberListeners;

        public MembershipExtension() {
        }

        protected MembershipExtension(Map<Address, Member> members, List<MemberListener> memberListeners) {
            this.members = members;
            this.memberListeners = memberListeners;
        }

        @Typed
        public Map<Address, Member> members(MemberEvents.Members members) {
            return new HashMap<Address, Member>(this.members);
        }

        @Typed
        public List<MemberListener> listeners(MemberEvents.Listeners listeners) {
            return new ArrayList<MemberListener>(this.memberListeners);
        }

        @Typed
        public void addListener(MemberEvents.AddListener add) {
            this.memberListeners.add(add.listener);
        }

        @Typed
        public void removeListener(MemberEvents.RemoveListener remove) {
            this.memberListeners.remove(remove.listener);
        }
    }

    public static class Membership
    extends Receptor<ClusterEvent.ClusterDomainEvent, Membership> {
        private Map<Address, Member> members = new HashMap<Address, Member>();
        private List<MemberListener> memberListeners = new ArrayList<MemberListener>();
        private MembershipExtension extension;

        public MembershipExtension getExtension() {
            return this.extension;
        }

        protected void initialize() {
            this.extension = (MembershipExtension)((MembershipExtension)this.addExtension(new MembershipExtension(this.members, this.memberListeners))).virtualize();
            Cluster cluster = Cluster.get((ActorSystem)this.getContext().getSystem());
            cluster.subscriptions().tell((Object)new Subscribe(this.getContext().getSelf(), ClusterEvent.ClusterDomainEvent.class));
        }

        @Typed
        void memberUp(ClusterEvent.MemberUp member) {
            this.members.put(member.member().address(), member.member());
            this.memberListeners.forEach(listener -> listener.memberUp(member.member().address().toString()));
        }

        @Typed
        void currentState(ClusterEvent.CurrentClusterState state) {
            for (Member member : state.getMembers()) {
                if (!member.status().equals(MemberStatus.up())) continue;
                this.members.put(member.address(), member);
                this.memberListeners.forEach(listener -> listener.memberUp(member.address().toString()));
            }
        }

        @Typed
        void removed(ClusterEvent.MemberRemoved member) {
            this.members.remove(member.member().address());
            this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
        }

        @Typed
        void unreachable(ClusterEvent.UnreachableMember member) {
            this.members.remove(member.member().address());
            this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
        }

        @Typed
        public void postStop(PostStop postStop) {
            Cluster cluster = Cluster.get((ActorSystem)this.getContext().getSystem());
            cluster.subscriptions().tell((Object)new Unsubscribe(this.getContext().getSelf()));
        }

        @Typed
        public Behavior<ClusterEvent.ClusterDomainEvent> terminated(Terminated terminated) {
            return Behaviors.stopped();
        }
    }
}

