/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.BeanParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import net.e6tech.elements.common.interceptor.CallFrame;
import net.e6tech.elements.common.interceptor.InstanceBuilder;
import net.e6tech.elements.common.interceptor.Interceptor;
import net.e6tech.elements.common.interceptor.InterceptorHandler;
import net.e6tech.elements.common.interceptor.InterceptorListener;
import net.e6tech.elements.common.reflection.Reflection;
import net.e6tech.elements.common.util.ExceptionMapper;
import net.e6tech.elements.common.util.datastructure.Pair;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.PostData;
import net.e6tech.elements.network.restful.Presentation;
import net.e6tech.elements.network.restful.Request;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;
import net.e6tech.elements.network.restful.WSResponseImpl;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;

public class RestfulProxy {
    private RestfulClient client;
    private Interceptor interceptor;
    private Map<String, String> requestProperties = new LinkedHashMap<String, String>();
    private PrintWriter printer;
    private Response lastResponse;

    public RestfulProxy(String hostAddress) {
        this.client = new RestfulClient(hostAddress);
        this.interceptor = Interceptor.getInstance();
    }

    public RestfulProxy(RestfulClient client) {
        this.client = client;
        this.interceptor = Interceptor.getInstance();
    }

    public ExceptionMapper getExceptionMapper() {
        return this.client.getExceptionMapper();
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.client.setExceptionMapper(exceptionMapper);
    }

    public PrintWriter getPrinter() {
        return this.printer;
    }

    public void setPrinter(PrintWriter printer) {
        this.printer = printer;
    }

    public String getHostAddress() {
        return this.client.getAddress();
    }

    public boolean isSkipHostnameCheck() {
        return this.client.isSkipHostnameCheck();
    }

    public void setSkipHostnameCheck(boolean skipHostnameCheck) {
        this.client.setSkipHostnameCheck(skipHostnameCheck);
    }

    public boolean isSkipCertCheck() {
        return this.client.isSkipCertCheck();
    }

    public void setSkipCertCheck(boolean skipCertCheck) {
        this.client.setSkipCertCheck(skipCertCheck);
    }

    public <T> T newProxy(Class<T> serviceClass) {
        this.client.setPrinter(this.printer);
        return (T)this.interceptor.newInstance(serviceClass, (InterceptorHandler)new InvocationHandler(this, serviceClass, null, this.printer));
    }

    public <T> T newProxy(Class<T> serviceClass, Presentation presentation) {
        this.client.setPrinter(this.printer);
        return (T)this.interceptor.newInstance(serviceClass, (InterceptorHandler)new InvocationHandler(this, serviceClass, presentation, this.printer));
    }

    public <T> T newProxy(Class<T> serviceClass, InterceptorListener listener) {
        this.client.setPrinter(this.printer);
        return (T)((InstanceBuilder)this.interceptor.instanceBuilder(serviceClass, (InterceptorHandler)new InvocationHandler(this, serviceClass, null, this.printer)).listener(listener)).build();
    }

    public <T> T newProxy(Class<T> serviceClass, Presentation presentation, InterceptorListener listener) {
        this.client.setPrinter(this.printer);
        return (T)((InstanceBuilder)this.interceptor.instanceBuilder(serviceClass, (InterceptorHandler)new InvocationHandler(this, serviceClass, presentation, this.printer)).listener(listener)).build();
    }

    public Map<String, String> getRequestProperties() {
        return Collections.unmodifiableMap(this.requestProperties);
    }

    public void setRequestProperties(Map<String, String> map) {
        this.requestProperties.putAll(map);
    }

    public void setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
    }

    public void clearRequestProperty(String key) {
        this.requestProperties.remove(key);
    }

    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public RestfulClient getClient() {
        return this.client;
    }

    private static class MethodForwarder {
        boolean get;
        boolean post;
        boolean put;
        boolean delete;
        Class returnType;
        ParameterizedType parameterizedReturnType;
        Class[] paramTypes;
        Parameter[] params;
        String context;
        QueryParam[] queryParams;
        PathParam[] pathParams;
        BeanParam[] beanParams;

        MethodForwarder(String context, Method method) {
            this.returnType = method.getReturnType();
            if (method.getGenericReturnType() instanceof ParameterizedType) {
                this.parameterizedReturnType = (ParameterizedType)method.getGenericReturnType();
            }
            this.paramTypes = method.getParameterTypes();
            this.context = context;
            this.queryParams = new QueryParam[this.paramTypes.length];
            this.pathParams = new PathParam[this.paramTypes.length];
            this.beanParams = new BeanParam[this.paramTypes.length];
            int idx = 0;
            for (Parameter param : this.params = method.getParameters()) {
                QueryParam queryParam = param.getAnnotation(QueryParam.class);
                PathParam pathParam = param.getAnnotation(PathParam.class);
                BeanParam beanParam = param.getAnnotation(BeanParam.class);
                if (queryParam != null) {
                    this.queryParams[idx] = queryParam;
                }
                if (pathParam != null) {
                    this.pathParams[idx] = pathParam;
                }
                if (beanParam != null) {
                    this.beanParams[idx] = beanParam;
                }
                ++idx;
            }
            if (method.getAnnotation(POST.class) != null) {
                this.post = true;
            } else if (method.getAnnotation(PUT.class) != null) {
                this.put = true;
            } else if (method.getAnnotation(GET.class) != null) {
                this.get = true;
            } else if (method.getAnnotation(DELETE.class) != null) {
                this.delete = true;
            } else {
                throw new IllegalArgumentException("Method " + method + " is not annotated with GET, PUT, POST or DELETE.");
            }
        }

        private Optional<Object> getValue(Object o, AccessibleObject a) {
            try {
                if (a instanceof Method) {
                    return Optional.ofNullable(((Method)a).invoke(o, new Object[0]));
                }
                if (a instanceof Field) {
                    return Optional.ofNullable(Reflection.getProperty((Object)o, (String)((Field)a).getName()));
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            return Optional.empty();
        }

        Pair<Response, Object> forward(Request request, Object[] args) throws Throwable {
            Type type;
            ArrayList<Param> paramList = new ArrayList<Param>();
            PostData postData = new PostData();
            String fullContext = this.context;
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (this.queryParams[i] != null && args[i] != null) {
                    Param p = new Param(this.queryParams[i].value(), args[i].toString());
                    paramList.add(p);
                }
                if (this.pathParams[i] != null) {
                    if (args[i] == null) {
                        throw new IllegalArgumentException("PathParam {" + this.pathParams[i].value() + "} cannot be null");
                    }
                    String value = args[i].toString();
                    String valueEscaped = URLEncoder.encode(value, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
                    fullContext = fullContext.replace("{" + this.pathParams[i].value() + "}", valueEscaped);
                }
                if (this.beanParams[i] != null && args[i] != null) {
                    Map.Entry entry2;
                    Object beanParamObj = args[i];
                    HashMap pathParamMap = new HashMap();
                    Reflection.forEachAnnotatedAccessor(beanParamObj.getClass(), PathParam.class, member -> {
                        String cfr_ignored_0 = pathParamMap.put(member.getAnnotation(PathParam.class).value(), this.getValue(beanParamObj, (AccessibleObject)member).map(Object::toString).orElse(null));
                    });
                    for (Map.Entry entry2 : pathParamMap.entrySet()) {
                        if (entry2.getValue() == null) {
                            throw new IllegalArgumentException("PathParam {" + (String)entry2.getKey() + "} cannot be null");
                        }
                        String valueEscaped = URLEncoder.encode((String)entry2.getValue(), StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
                        fullContext = fullContext.replace("{" + (String)entry2.getKey() + "}", valueEscaped);
                    }
                    HashMap queryParamMap = new HashMap();
                    Reflection.forEachAnnotatedAccessor(beanParamObj.getClass(), QueryParam.class, member -> {
                        String cfr_ignored_0 = queryParamMap.put(member.getAnnotation(QueryParam.class).value(), this.getValue(beanParamObj, (AccessibleObject)member).map(Object::toString).orElse(null));
                    });
                    entry2 = queryParamMap.entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        if (entry3.getValue() == null) continue;
                        Param p = new Param((String)entry3.getKey(), (String)entry3.getValue());
                        paramList.add(p);
                    }
                }
                if (this.pathParams[i] != null || this.queryParams[i] != null || this.beanParams[i] != null) continue;
                postData.setData(args[i]);
                postData.setSpecified(true);
            }
            Response response = null;
            if (this.post) {
                response = request.post(fullContext, postData.getData(), paramList.toArray(new Param[paramList.size()]));
            } else if (this.put) {
                response = request.put(fullContext, postData.getData(), paramList.toArray(new Param[paramList.size()]));
            } else if (this.get) {
                response = request.get(fullContext, paramList.toArray(new Param[paramList.size()]));
            } else if (this.delete) {
                response = postData.isSpecified() ? request.delete(fullContext, postData.getData(), paramList.toArray(new Param[paramList.size()])) : request.delete(fullContext, paramList.toArray(new Param[paramList.size()]));
            } else {
                throw new IllegalArgumentException("Unknown HTTP method");
            }
            if (javax.ws.rs.core.Response.class.isAssignableFrom(this.returnType)) {
                WSResponseImpl impl = new WSResponseImpl(response);
                return new Pair((Object)response, (Object)impl);
            }
            if (this.returnType.equals(Void.TYPE)) {
                return new Pair((Object)response, null);
            }
            if (this.parameterizedReturnType != null && (type = this.parameterizedReturnType.getRawType()) instanceof Class) {
                Class encloseType = (Class)type;
                if (Collection.class.isAssignableFrom(encloseType)) {
                    Class elementType = (Class)this.parameterizedReturnType.getActualTypeArguments()[0];
                    CollectionType ctype = TypeFactory.defaultInstance().constructCollectionType(encloseType, elementType);
                    return new Pair((Object)response, Response.mapper.readValue(response.getResult(), (JavaType)ctype));
                }
                if (Map.class.isAssignableFrom(encloseType)) {
                    Class keyType = (Class)this.parameterizedReturnType.getActualTypeArguments()[0];
                    Class valueType = (Class)this.parameterizedReturnType.getActualTypeArguments()[1];
                    MapType mtype = TypeFactory.defaultInstance().constructMapType(encloseType, keyType, valueType);
                    return new Pair((Object)response, Response.mapper.readValue(response.getResult(), (JavaType)mtype));
                }
            }
            return new Pair((Object)response, response.read(this.returnType));
        }
    }

    private static class InvocationHandler
    implements InterceptorHandler {
        private RestfulProxy proxy;
        private String context;
        private Map<Method, MethodForwarder> methodForwarders = new ConcurrentHashMap();
        private Map<Method, String> methodSignatures = new ConcurrentHashMap();
        private Presentation presentation;
        private PrintWriter printer;

        InvocationHandler(RestfulProxy proxy, Class<?> serviceClass, Presentation presentation, PrintWriter printer) {
            this.proxy = proxy;
            this.presentation = presentation;
            this.printer = printer;
            Path path = serviceClass.getAnnotation(Path.class);
            if (path != null) {
                this.context = path.value();
                if (!this.context.endsWith("/")) {
                    this.context = path.value() + "/";
                }
            } else {
                this.context = "/";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(CallFrame frame) throws Throwable {
            if (this.printer != null) {
                String signature = this.methodSignatures.computeIfAbsent(frame.getMethod(), this::methodSignature);
                String caller = Reflection.mapCallingStackTrace(e -> {
                    if (e.state().isPresent()) {
                        return ((StackTraceElement)e.get()).toString();
                    }
                    if (((StackTraceElement)e.get()).getMethodName().equals(frame.getMethod().getName())) {
                        e.state((Object)Boolean.TRUE);
                    }
                    return null;
                }).orElse("Cannot detect caller");
                this.printer.println("Called by: " + (String)caller);
                this.printer.println(signature);
            }
            Request request = this.proxy.client.create();
            if (this.presentation != null) {
                request.setPresentation(this.presentation);
            }
            for (Map.Entry entry : this.proxy.requestProperties.entrySet()) {
                request.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            String fullContext = this.context;
            Path path = (Path)frame.getAnnotation(Path.class);
            if (path != null) {
                String subctx = path.value();
                while (subctx.startsWith("/")) {
                    subctx = subctx.substring(1);
                }
                fullContext = this.context + subctx;
            }
            String ctx = fullContext;
            MethodForwarder forwarder = this.methodForwarders.computeIfAbsent(frame.getMethod(), key -> new MethodForwarder(ctx, (Method)key));
            Pair<Response, Object> pair = forwarder.forward(request, frame.getArguments());
            RestfulProxy restfulProxy = this.proxy;
            synchronized (restfulProxy) {
                this.proxy.lastResponse = (Response)pair.key();
            }
            return pair.value();
        }

        String methodSignature(Method method) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(method.getReturnType().getSimpleName()).append(' ');
                sb.append(method.getDeclaringClass().getTypeName()).append('.');
                sb.append(method.getName());
                sb.append('(');
                this.separateWithCommas(method.getParameterTypes(), sb);
                sb.append(')');
                return sb.toString();
            }
            catch (Exception e) {
                return "<" + e + ">";
            }
        }

        void separateWithCommas(Class<?>[] types, StringBuilder sb) {
            for (int j = 0; j < types.length; ++j) {
                sb.append(types[j].getSimpleName());
                if (j >= types.length - 1) continue;
                sb.append(",");
            }
        }
    }
}

