/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.Status;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.DispatcherSelector;
import akka.actor.typed.Props;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.GroupRouter;
import akka.actor.typed.javadsl.Routers;
import akka.actor.typed.receptionist.Receptionist;
import akka.actor.typed.receptionist.ServiceKey;
import akka.japi.function.Function;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;
import net.e6tech.elements.network.cluster.invocation.RegistryEntry;
import net.e6tech.elements.network.cluster.invocation.RegistryImpl;
import scala.concurrent.ExecutionContextExecutor;

public class Registrar
extends Receptor<InvocationEvents, Registrar> {
    private Map<String, ActorRef<InvocationEvents.Request>> routes = new HashMap<String, ActorRef<InvocationEvents.Request>>();
    private Map<String, Set<ActorRef<InvocationEvents.Request>>> actors = new ConcurrentHashMap<String, Set<ActorRef<InvocationEvents.Request>>>();
    private Map<ActorRef<InvocationEvents.Request>, String> actorKeys = new ConcurrentHashMap<ActorRef<InvocationEvents.Request>, String>();
    private RegistryImpl registry;

    public Registrar(RegistryImpl registry) {
        this.registry = registry;
    }

    @Typed
    private void registration(InvocationEvents.Registration registration) {
        ExecutionContextExecutor executor = this.getContext().getSystem().dispatchers().lookup(DispatcherSelector.fromConfig((String)"registry-dispatcher"));
        String dispatcher = executor != null ? "registry-dispatcher" : "worker-pool-dispatcher";
        ServiceKey key = ServiceKey.create(InvocationEvents.Request.class, (String)registration.getPath());
        this.getContext().spawnAnonymous(Behaviors.setup((Function & Serializable)ctx -> {
            ctx.getSystem().receptionist().tell((Object)Receptionist.subscribe((ServiceKey)key, (ActorRef)ctx.getSelf().narrow()));
            return Behaviors.receive(Object.class).onMessage(Receptionist.Listing.class, (Function & Serializable)msg -> {
                Map<String, Set<ActorRef<InvocationEvents.Request>>> map = this.actors;
                synchronized (map) {
                    Set set = this.actors.getOrDefault(registration.getPath(), Collections.emptySet());
                    for (ActorRef ref : set) {
                        this.actorKeys.remove(ref);
                    }
                    for (ActorRef ref : msg.getServiceInstances(key)) {
                        this.actorKeys.put((ActorRef<InvocationEvents.Request>)ref, registration.getPath());
                        if (set.contains(ref)) continue;
                        this.getContext().watch(ref);
                        this.registry.onAnnouncement(registration.getPath());
                    }
                    this.actors.put(registration.getPath(), new LinkedHashSet(msg.getServiceInstances(key)));
                }
                return Behaviors.same();
            }).build();
        }));
        ActorRef registryEntry = this.childActor(RegistryEntry.class).withProps((Props)DispatcherSelector.fromConfig((String)dispatcher)).spawn((Receptor)new RegistryEntry(registration));
        this.getSystem().receptionist().tell((Object)Receptionist.register((ServiceKey)key, (ActorRef)registryEntry));
        this.routes.computeIfAbsent(registration.getPath(), k -> {
            GroupRouter g = Routers.group((ServiceKey)key).withRoundRobinRouting();
            return this.getContext().spawnAnonymous((Behavior)g);
        });
    }

    @Typed
    private void request(InvocationEvents.Request request) {
        ActorRef<InvocationEvents.Request> router = this.routes.get(request.getPath());
        if (router == null) {
            request.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")));
        } else {
            router.tell((Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Typed
    private void terminated(Terminated terminated) {
        String key;
        ActorRef actor = terminated.getRef();
        Map<String, Set<ActorRef<InvocationEvents.Request>>> map = this.actors;
        synchronized (map) {
            Set<ActorRef<InvocationEvents.Request>> set;
            key = this.actorKeys.get(actor);
            if (key != null && (set = this.actors.get(key)) != null) {
                set.remove(actor);
            }
            this.actorKeys.remove(actor);
        }
        if (key != null) {
            this.registry.onTerminated(key, actor);
        }
    }

    @Typed
    private void routes(InvocationEvents.Routes message) {
        Set<ActorRef<InvocationEvents.Request>> actorsForKey = this.actors.get(message.getPath());
        if (actorsForKey == null) {
            message.getSender().tell((Object)new InvocationEvents.Response(this.getSelf(), Collections.emptySet()));
        } else {
            message.getSender().tell((Object)new InvocationEvents.Response(this.getSelf(), actorsForKey));
        }
    }
}

