/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.e6tech.elements.network.restful.Param;
import net.e6tech.elements.network.restful.PostData;
import net.e6tech.elements.network.restful.Presentation;
import net.e6tech.elements.network.restful.Response;
import net.e6tech.elements.network.restful.RestfulClient;

public class Request {
    private static final Presentation singleton = new Presentation(){};
    static final String GET = "GET";
    static final String PUT = "PUT";
    static final String PATCH = "PATCH";
    static final String POST = "POST";
    static final String DELETE = "DELETE";
    private RestfulClient client;
    private Map<String, String> requestProperties = new LinkedHashMap<String, String>();
    private Presentation presentation = singleton;

    Request(RestfulClient client) {
        this.client = client;
    }

    public Request setRequestProperty(String key, String value) {
        this.requestProperties.put(key, value);
        return this;
    }

    public Request setRequestProperties(Map<String, String> map) {
        this.requestProperties.putAll(map);
        return this;
    }

    public Map<String, String> getRequestProperties() {
        return Collections.unmodifiableMap(this.requestProperties);
    }

    public void clearRequestProperty(String key) {
        this.requestProperties.remove(key);
    }

    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    public Response get(String context, Param ... params) throws Exception {
        return this.request(context, GET, new PostData(), params);
    }

    public Response delete(String context, Object data, Param ... params) throws Exception {
        return this.request(context, DELETE, new PostData(data), params);
    }

    public Response delete(String context, Param ... params) throws Exception {
        return this.request(context, DELETE, new PostData(), params);
    }

    public Response put(String context, Object data, Param ... params) throws Exception {
        return this.request(context, PUT, new PostData(data), params);
    }

    public Response patch(String context, Object data, Param ... params) throws Exception {
        return this.request(context, PATCH, new PostData(data), params);
    }

    public Response post(String context, Object data, Param ... params) throws Exception {
        return this.request(context, POST, new PostData(data), params);
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public void setPresentation(Presentation presentation) {
        this.presentation = presentation;
    }

    public Response request(String context, String method, PostData postData, Param ... params) throws Exception {
        this.getPresentation().formatRequest(this);
        if (postData == null) {
            postData = new PostData();
        }
        if (postData.isSpecified()) {
            postData.setData(this.getPresentation().formatPostData(postData.getData()));
        }
        Response response = this.client.submit(context, method, this.requestProperties, postData, this.getPresentation().formatQuery(params));
        return this.getPresentation().formatResponse(response);
    }
}

