/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.network.proxy.Transfer;

public class SocketProxyServer
implements Startable,
Runnable {
    private static Logger logger = Logger.getLogger();
    private String remoteHost;
    private int remotePort;
    private int localPort;
    private ExecutorService threadPool;
    private volatile boolean stopped = false;

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void start() {
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(runnable, "SocketProxyServer");
                thread.setName("SocketProxyServer-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.stopped = false;
        this.threadPool.execute(this);
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public void run() {
        try (ServerSocket serverSocket = new ServerSocket(this.localPort);){
            while (!this.stopped) {
                try {
                    Transfer transfer = new Transfer(this.remoteHost, this.remotePort, serverSocket.accept(), this.threadPool);
                    this.threadPool.execute(transfer);
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception th) {
            throw logger.systemException((Throwable)th);
        }
    }
}

