/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.typed.ActorRef;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.BiFunction;
import net.e6tech.elements.common.actor.typed.Ask;
import net.e6tech.elements.common.util.CompressionSerializer;
import net.e6tech.elements.common.util.SystemException;

public interface InvocationEvents
extends Serializable {

    public static class Routes
    extends Ask
    implements InvocationEvents {
        private RegisterReference reference;

        public Routes(ActorRef sender, String path) {
            this.reference = new RegisterReference(path);
            this.setSender(sender);
        }

        public String getPath() {
            return this.reference.getPath();
        }
    }

    public static class Response
    implements InvocationEvents {
        private Object value;
        private ActorRef responder;

        public Response(ActorRef responder, Object value) {
            this.value = value;
            this.responder = responder;
        }

        public Object getValue() {
            return this.value;
        }

        public ActorRef getResponder() {
            return this.responder;
        }
    }

    public static class Request
    extends Ask
    implements InvocationEvents,
    KryoSerializable {
        private static final long serialVersionUID = -264975294117974773L;
        private transient RegisterReference reference;
        private transient Object[] arguments;
        private long timeout;

        public Request(ActorRef<Response> sender, String path, long timeout, Object[] arguments) {
            this.reference = new RegisterReference(path);
            this.arguments = arguments;
            this.timeout = timeout;
            this.setSender(sender);
        }

        public Object[] arguments() {
            return this.arguments;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void write(Kryo kryo, Output out) {
            byte[] payload;
            CompressionSerializer serializer = new CompressionSerializer();
            try {
                payload = serializer.toBytes((Object)this.arguments);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            kryo.writeObjectOrNull(out, (Object)payload, byte[].class);
            kryo.writeObjectOrNull(out, (Object)this.reference, RegisterReference.class);
            kryo.writeObjectOrNull(out, (Object)this.getSender(), ActorRef.class);
            kryo.writeObject(out, (Object)this.timeout);
        }

        public void read(Kryo kryo, Input in) {
            byte[] buffer = (byte[])kryo.readObjectOrNull(in, byte[].class);
            this.reference = (RegisterReference)kryo.readObjectOrNull(in, RegisterReference.class);
            this.setSender((ActorRef)kryo.readObjectOrNull(in, ActorRef.class));
            this.timeout = (Long)kryo.readObject(in, Long.class);
            try {
                this.arguments = (Object[])CompressionSerializer.fromBytes((byte[])buffer);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            CompressionSerializer serializer = new CompressionSerializer();
            byte[] payload = serializer.toBytes((Object)this.arguments);
            out.write(payload);
            out.writeInt(payload.length);
            out.writeObject(this.reference);
            out.writeObject(this.getSender());
            out.writeLong(this.timeout);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.timeout = in.readLong();
            this.setSender((ActorRef)in.readObject());
            this.reference = (RegisterReference)in.readObject();
            int size = in.readInt();
            byte[] buffer = new byte[size];
            in.readFully(buffer);
            this.arguments = (Object[])CompressionSerializer.fromBytes((byte[])buffer);
        }

        public String getPath() {
            return this.reference.getPath();
        }
    }

    public static class Registration
    extends Ask
    implements InvocationEvents {
        private RegisterReference reference;
        private BiFunction<ActorRef, Object[], Object> function;

        public Registration(ActorRef sender, String path, BiFunction<ActorRef, Object[], Object> function) {
            this.reference = new RegisterReference(path);
            this.function = function;
            this.setSender(sender);
        }

        public BiFunction<ActorRef, Object[], Object> getFunction() {
            return this.function;
        }

        public String getPath() {
            return this.reference.getPath();
        }
    }

    public static class RegisterReference
    implements Serializable {
        private static final long serialVersionUID = 6460401252394771795L;
        private String path;

        public RegisterReference() {
        }

        public RegisterReference(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

