/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.typed.ActorRef;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.network.cluster.ClusterAsync;
import net.e6tech.elements.network.cluster.RouteListener;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;
import net.e6tech.elements.network.cluster.invocation.Invoker;

public interface Registry {
    public void start(Guardian var1);

    public void shutdown();

    public long getTimeout();

    public void setTimeout(long var1);

    public void addRouteListener(RouteListener var1);

    public void removeRouteListener(RouteListener var1);

    public Collection routes(String var1);

    public Collection routes(String var1, Class var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void waitLoop(BooleanSupplier test, long timeout) throws TimeoutException {
        final Object monitor = new Object();
        RouteListener listener = new RouteListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnnouncement(String path) {
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                }
            }
        };
        try {
            this.addRouteListener(listener);
            long start = System.currentTimeMillis();
            boolean first = true;
            Object object = monitor;
            synchronized (object) {
                while (!test.getAsBoolean()) {
                    if (!first && System.currentTimeMillis() - start > timeout) {
                        throw new TimeoutException();
                    }
                    if (first) {
                        first = false;
                    }
                    try {
                        long wait = timeout - (System.currentTimeMillis() - start);
                        if (wait <= 0L) continue;
                        monitor.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
        finally {
            this.removeRouteListener(listener);
        }
    }

    default public void waitForRoutes(String qualifier, Predicate<Collection> predicate, long timeout) throws TimeoutException {
        this.waitLoop(() -> predicate.test(this.routes(qualifier)), timeout);
    }

    default public void waitForRoutes(String qualifier, Class interfaceClass, Predicate<Collection> predicate, long timeout) throws TimeoutException {
        this.waitLoop(() -> predicate.test(this.routes(qualifier, interfaceClass)), timeout);
    }

    public <R, U> CompletionStage<U> register(String var1, BiFunction<ActorRef, Object[], R> var2);

    public <T, U> CompletionStage<List<U>> register(String var1, Class<T> var2, T var3);

    public <T, U> CompletionStage<List<U>> discover(String var1, Class<T> var2);

    public <T, U> CompletionStage<List<U>> register(String var1, Class<T> var2, T var3, Invoker var4);

    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String var1, Class var2, Method var3, long var4);

    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String var1, long var2);

    public <T> ClusterAsync<T> async(String var1, Class<T> var2);

    public <T> ClusterAsync<T> async(String var1, Class<T> var2, long var3);
}

