/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.messaging;

import akka.actor.ActorRef;
import akka.actor.typed.DispatcherSelector;
import akka.actor.typed.javadsl.Behaviors;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.japi.function.Function;
import java.io.Serializable;
import net.e6tech.elements.common.actor.typed.Receptor;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.messaging.MessagingEvents;

public class SubscriberActor
extends Receptor<MessagingEvents, SubscriberActor> {
    private Subscriber subscriber;
    private String topic;

    public SubscriberActor() {
    }

    public SubscriberActor(String topic, Subscriber subscriber) {
        this.subscriber = subscriber;
        this.topic = topic;
    }

    protected void initialize() {
        ActorRef mediator = DistributedPubSub.lookup().get(this.untypedContext().system()).mediator();
        mediator.tell((Object)new DistributedPubSubMediator.Subscribe(this.topic, this.untypedRef()), this.untypedRef());
        this.getContext().spawnAnonymous(Behaviors.receive(DistributedPubSubMediator.SubscribeAck.class).onMessage(DistributedPubSubMediator.SubscribeAck.class, (Function & Serializable)msg -> {
            this.getSystem().log().info("subscribed to {}", (Object)msg.toString());
            return Behaviors.same();
        }).build());
    }

    @Typed
    private void publish(MessagingEvents.Publish publish) {
        this.getContext().getSystem().dispatchers().lookup(DispatcherSelector.defaultDispatcher()).execute(() -> this.subscriber.receive(new Notice(publish.getTopic(), (Serializable)publish.getMessage())));
    }
}

