/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;
import net.e6tech.elements.network.cluster.catalyst.transform.Transform;

public class Union<Re extends Reactor, T>
implements Transform<Re, T, T> {
    private transient DataSet<T> dataSet;
    private Collection<Segment<T>> segments = new ArrayList<Segment<T>>();

    public Union(DataSet<T> dataSet) {
        this.dataSet = dataSet;
    }

    protected Union(Collection<Segment<T>> segments) {
        this.segments = segments;
    }

    @Override
    public Stream<T> transform(Re reactor, Stream<T> stream) {
        HashSet set = new HashSet();
        for (Segment<T> segment : this.segments) {
            segment.stream((Reactor)reactor).collect(Collectors.toCollection(() -> set));
        }
        ArrayList union = new ArrayList(set);
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (set.contains(t)) continue;
            union.add(t);
        }
        return union.stream();
    }

    public Union<Re, T> allocate(Segments<?> root) {
        return new Union<Re, T>(root.segment(this.dataSet));
    }
}

