/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRefResolver;
import akka.actor.typed.javadsl.Adapter;
import akka.serialization.Serialization;
import akka.serialization.SerializerWithStringManifest;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.ClosureSerializer;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import net.e6tech.elements.common.util.SystemException;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.SerializingInstantiatorStrategy;

public class Serializer
extends SerializerWithStringManifest {
    private Pool<Kryo> pool;
    private Pool<Output> outputPool;
    private ActorRefSerializer actorRefSerializer;
    private TypedActorRefSerializer typedActorRefSerializer;
    private Cache<String, Class> classCache = CacheBuilder.newBuilder().concurrencyLevel(32).initialCapacity(128).expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(500L).build();

    public Serializer(ExtendedActorSystem actorSystem) {
        this.pool = new Pool<Kryo>(true, false, 64){

            protected Kryo create() {
                Kryo kryo = new Kryo();
                kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
                kryo.setRegistrationRequired(false);
                kryo.addDefaultSerializer(akka.actor.ActorRef.class, (com.esotericsoftware.kryo.Serializer)Serializer.this.actorRefSerializer);
                kryo.addDefaultSerializer(ActorRef.class, (com.esotericsoftware.kryo.Serializer)Serializer.this.typedActorRefSerializer);
                kryo.register(SerializedLambda.class);
                kryo.register(ClosureSerializer.Closure.class, (com.esotericsoftware.kryo.Serializer)new ClosureSerializer());
                return kryo;
            }
        };
        this.outputPool = new Pool<Output>(true, false, 64){

            protected Output create() {
                return new Output(4096, -1);
            }
        };
        this.actorRefSerializer = new ActorRefSerializer(actorSystem);
        this.typedActorRefSerializer = new TypedActorRefSerializer(actorSystem);
    }

    public int identifier() {
        return 6408;
    }

    public String manifest(Object obj) {
        return obj.getClass().getName();
    }

    public byte[] toBinary(Object obj) {
        Kryo kryo = (Kryo)this.pool.obtain();
        Output output = (Output)this.outputPool.obtain();
        kryo.writeObject(output, obj);
        output.close();
        byte[] bytes = output.toBytes();
        this.pool.free((Object)kryo);
        this.outputPool.free((Object)output);
        return bytes;
    }

    public Object fromBinary(byte[] bytes, String manifest) {
        Kryo kryo = (Kryo)this.pool.obtain();
        Class<?> cls = (Class<?>)this.classCache.getIfPresent((Object)manifest);
        if (cls == null) {
            try {
                cls = ((Object)((Object)this)).getClass().getClassLoader().loadClass(manifest);
                this.classCache.put((Object)manifest, cls);
            }
            catch (ClassNotFoundException e) {
                throw new SystemException((Throwable)e);
            }
        }
        Input input = new Input();
        input.setBuffer(bytes);
        Object object = kryo.readObject(input, cls);
        input.close();
        this.pool.free((Object)kryo);
        return object;
    }

    public class TypedActorRefSerializer
    extends com.esotericsoftware.kryo.Serializer<ActorRef> {
        private final ExtendedActorSystem system;
        private final ActorRefResolver actorRefResolver;

        public ExtendedActorSystem system() {
            return this.system;
        }

        public void write(Kryo kryo, Output output, ActorRef obj) {
            String str = this.actorRefResolver.toSerializationFormat(obj);
            output.writeString(str);
        }

        public ActorRef read(Kryo kryo, Input input, Class<? extends ActorRef> type) {
            String str = input.readString();
            return this.actorRefResolver.resolveActorRef(str);
        }

        public TypedActorRefSerializer(ExtendedActorSystem system) {
            this.system = system;
            this.actorRefResolver = ActorRefResolver.get((akka.actor.typed.ActorSystem)Adapter.toTyped((ActorSystem)system));
        }
    }

    public class ActorRefSerializer
    extends com.esotericsoftware.kryo.Serializer<akka.actor.ActorRef> {
        private final ExtendedActorSystem system;

        public ExtendedActorSystem system() {
            return this.system;
        }

        public void write(Kryo kryo, Output output, akka.actor.ActorRef obj) {
            output.writeString(Serialization.serializedActorPath((akka.actor.ActorRef)obj));
        }

        public akka.actor.ActorRef read(Kryo kryo, Input input, Class<? extends akka.actor.ActorRef> type) {
            String str = input.readString();
            return this.system().provider().resolveActorRef(str);
        }

        public ActorRefSerializer(ExtendedActorSystem system) {
            this.system = system;
        }
    }
}

