/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.japi.Creator;
import akka.pattern.Patterns;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.e6tech.elements.common.actor.pool.WorkerPool;
import net.e6tech.elements.common.util.concurrent.ThreadPool;
import net.e6tech.elements.network.cluster.AsyncImpl;
import net.e6tech.elements.network.cluster.ClusterAsync;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.Invoker;
import net.e6tech.elements.network.cluster.Local;
import net.e6tech.elements.network.cluster.RegistrarActor;
import net.e6tech.elements.network.cluster.RouteListener;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class Registry {
    private static String path = "registry";
    public static final String REGISTRY_DISPATCHER = "registry-dispatcher";
    private static ThreadPool threadPool = ThreadPool.cachedThreadPool((String)"Cluster-Registry");
    ActorSystem system;
    ActorRef registrar;
    ActorRef workerPool;
    long timeout = 10000L;
    List<RouteListener> listeners = new ArrayList<RouteListener>();

    public static ThreadPool getThreadPool() {
        return threadPool;
    }

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        Registry.path = path;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    void onRouteRemoved(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onRouteRemoved(path);
            }
        });
    }

    public ActorRef getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ActorRef workerPool) {
        this.workerPool = workerPool;
    }

    public void start(ActorSystem system) {
        this.system = system;
        if (this.workerPool == null) {
            this.workerPool = system.actorOf(Props.create(WorkerPool.class, (Object[])new Object[0]));
        }
        this.registrar = system.actorOf(Props.create(RegistrarActor.class, (Creator & Serializable)() -> new RegistrarActor(this, this.workerPool)), Registry.getPath());
    }

    public void shutdown() {
        Patterns.ask((ActorRef)this.registrar, (Object)PoisonPill.getInstance(), (long)this.timeout);
    }

    public <R> void register(String path, BiFunction<Actor, Object[], R> function, long timeout) {
        Patterns.ask((ActorRef)this.registrar, (Object)new Events.Registration(path, function, timeout), (long)this.timeout);
    }

    public <T> Collection routes(String qualifier, Class<T> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            String p = this.fullyQualify(qualifier, interfaceClass, method);
            return this.routes(p);
        }
        return Collections.emptyList();
    }

    public Collection routes(String path) {
        Future future = Patterns.ask((ActorRef)this.registrar, (Object)new Events.Routes(path), (long)this.timeout);
        return (Collection)((CompletableFuture)FutureConverters.toJava((Future)future).toCompletableFuture().thenApply(response -> (Collection)response.getValue())).join();
    }

    public <T> void register(String qualifier, Class<T> interfaceClass, T implementation, long timeout) {
        this.register(qualifier, interfaceClass, implementation, null, timeout);
    }

    public <T> void register(String qualifier, Class<T> interfaceClass, T implementation, Invoker customizedInvoker, long timeout) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            if (customizedInvoker == null) {
                customizedInvoker = new Invoker();
            }
            Invoker invoker = customizedInvoker;
            this.register(this.fullyQualify(qualifier, interfaceClass, method), (actor, args) -> invoker.invoke((Actor)actor, implementation, method, (Object[])args), timeout);
        }
    }

    String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        String normalizedQualifier;
        StringBuilder builder = new StringBuilder();
        String string = normalizedQualifier = qualifier == null ? "" : qualifier.trim();
        if (normalizedQualifier.length() > 0) {
            builder.append(normalizedQualifier);
            builder.append("@");
        }
        builder.append(interfaceClass.getName());
        builder.append("::");
        builder.append(method.getName());
        builder.append("(");
        boolean first = true;
        for (Class<?> param : method.getParameterTypes()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(param.getTypeName());
        }
        builder.append(")");
        return builder.toString();
    }

    public Function<Object[], CompletionStage<Events.Response>> route(String qualifier, Class interfaceClass, Method method, long timeout) {
        return this.route(this.fullyQualify(qualifier, interfaceClass, method), timeout);
    }

    public Function<Object[], CompletionStage<Events.Response>> route(String path, long timeout) {
        return arguments -> {
            Future future = Patterns.ask((ActorRef)this.registrar, (Object)new Events.Invocation(path, (Object[])arguments), (long)timeout);
            return FutureConverters.toJava((Future)future).thenApplyAsync(ret -> ret);
        };
    }

    public <T> ClusterAsync<T> async(String qualifier, Class<T> interfaceClass) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, this.getTimeout());
    }

    public <T> ClusterAsync<T> async(String qualifier, Class<T> interfaceClass, long timeout) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, timeout);
    }
}

