/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.legacy;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.Terminated;
import akka.japi.Creator;
import akka.routing.RoundRobinRoutingLogic;
import akka.routing.Router;
import akka.routing.RoutingLogic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.network.cluster.legacy.Events;
import net.e6tech.elements.network.cluster.legacy.RegistryEntryActor;
import net.e6tech.elements.network.cluster.legacy.RegistryImpl;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

class RegistrarActor
extends AbstractActor {
    private Map<String, Router> routes = new HashMap<String, Router>();
    private Map<ActorRef, List<String>> actors = new HashMap<ActorRef, List<String>>();
    private RegistryImpl registry;

    public RegistrarActor(RegistryImpl registry) {
        this.registry = registry;
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Events.Registration.class, message -> {
            String dispatcher = this.getContext().getSystem().dispatchers().hasDispatcher("registry-dispatcher") ? "registry-dispatcher" : "worker-pool-dispatcher";
            Props props = Props.create(RegistryEntryActor.class, (Creator & Serializable)() -> new RegistryEntryActor(this.registry.getGuardian(), (Events.Registration)message)).withDispatcher(dispatcher);
            ActorRef entry = this.getContext().actorOf(props);
            this.getSender().tell((Object)entry, this.getSelf());
        }).match(Events.Announcement.class, message -> {
            this.getContext().watch(this.getSender());
            Router router = this.routes.computeIfAbsent(message.path(), cls -> new Router((RoutingLogic)new RoundRobinRoutingLogic()));
            router = router.addRoutee(this.getSender());
            this.routes.put(message.path(), router);
            List paths = this.actors.computeIfAbsent(this.getSender(), ref -> new ArrayList());
            paths.add(message.path());
            this.registry.onAnnouncement(message.path());
        }).match(Terminated.class, terminated -> {
            ActorRef actor = terminated.getActor();
            List<String> paths = this.actors.get(actor);
            if (paths != null) {
                for (String path : paths) {
                    Router router = this.routes.get(path);
                    this.onTerminated(path, router, actor);
                }
                this.actors.remove(actor);
            }
        }).match(Events.Invocation.class, invocation -> {
            Router router = this.routes.get(invocation.path());
            if (router == null || router.routees().length() == 0) {
                this.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")), this.getSelf());
            } else {
                router.route(invocation, this.getSender());
            }
        }).match(Events.Routes.class, r -> {
            Router router = this.routes.get(r.path());
            if (router == null || router.routees().length() == 0) {
                this.getSender().tell((Object)new Events.Response(Collections.emptyList(), this.getSelf()), this.getSelf());
            } else {
                Collection collection = JavaConverters.asJavaCollection((Iterable)router.routees());
                this.getSender().tell((Object)new Events.Response(collection, this.getSelf()), this.getSelf());
            }
        }).build();
    }

    private void onTerminated(String path, Router router, ActorRef actor) {
        if (router == null) {
            return;
        }
        this.registry.onTerminated(path, actor);
        Router newRouter = router.removeRoutee(this.getSender());
        this.routes.put(path, newRouter);
    }
}

