/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.legacy;

import akka.actor.typed.ActorRef;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.function.BiFunction;
import net.e6tech.elements.common.util.CompressionSerializer;
import net.e6tech.elements.common.util.SystemException;

public class Events {
    private Events() {
    }

    public static class Response
    implements Serializable {
        private Object value;
        private akka.actor.ActorRef responder;

        public Response() {
        }

        public Response(Object value, akka.actor.ActorRef responder) {
            this.value = value;
            this.responder = responder;
        }

        public Object getValue() {
            return this.value;
        }

        public akka.actor.ActorRef getResponder() {
            return this.responder;
        }
    }

    public static class Routes {
        private RegisterReference reference;

        public Routes(String path) {
            this.reference = new RegisterReference(path);
        }

        public String path() {
            return this.reference.path();
        }
    }

    public static class Invocation
    implements Serializable,
    KryoSerializable {
        private static final long serialVersionUID = -264975294117974773L;
        private transient RegisterReference reference;
        private transient Object[] arguments;
        private long timeout = 10000L;

        public Invocation() {
        }

        public Invocation(String path, Object[] arguments) {
            this.reference = new RegisterReference(path);
            this.arguments = arguments;
        }

        public Object[] arguments() {
            return this.arguments;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void write(Kryo kryo, Output out) {
            byte[] payload;
            CompressionSerializer serializer = new CompressionSerializer();
            try {
                payload = serializer.toBytes((Object)this.arguments);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            kryo.writeObjectOrNull(out, (Object)payload, byte[].class);
            kryo.writeObjectOrNull(out, (Object)this.reference, RegisterReference.class);
            kryo.writeObject(out, (Object)this.timeout);
        }

        public void read(Kryo kryo, Input in) {
            byte[] buffer = (byte[])kryo.readObjectOrNull(in, byte[].class);
            this.reference = (RegisterReference)kryo.readObjectOrNull(in, RegisterReference.class);
            this.timeout = (Long)kryo.readObject(in, Long.class);
            try {
                this.arguments = (Object[])CompressionSerializer.fromBytes((byte[])buffer);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            CompressionSerializer serializer = new CompressionSerializer();
            byte[] payload = serializer.toBytes((Object)this.arguments);
            out.writeInt(payload.length);
            out.write(payload);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            byte[] buffer = new byte[size];
            in.readFully(buffer);
            this.arguments = (Object[])CompressionSerializer.fromBytes((byte[])buffer);
        }

        public String path() {
            return this.reference.path();
        }
    }

    public static class Registration {
        private RegisterReference reference;
        private BiFunction<ActorRef, Object[], Object> function;

        public Registration(String path, BiFunction<ActorRef, Object[], Object> function) {
            this.reference = new RegisterReference(path);
            this.function = function;
        }

        public BiFunction<ActorRef, Object[], Object> function() {
            return this.function;
        }

        public String getPath() {
            return this.reference.path();
        }
    }

    public static class Announcement
    implements Serializable {
        private static final long serialVersionUID = 6910153191195648915L;
        private RegisterReference reference;

        public Announcement() {
        }

        public Announcement(Registration register) {
            this.reference = register.reference;
        }

        public String path() {
            return this.reference.path();
        }
    }

    private static class RegisterReference
    implements Serializable {
        private static final long serialVersionUID = 6460401252394771795L;
        private String path;

        public RegisterReference() {
        }

        public RegisterReference(String path) {
            this.path = path;
        }

        public String path() {
            return this.path;
        }
    }
}

