/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;

public class Segments<E> {
    private Map<DataSet, Segments> dependents = new HashMap<DataSet, Segments>();
    private LinkedList<Segment<E>> segments = new LinkedList();
    private Catalyst catalyst;

    public Segments(Catalyst catalyst, Collection<Segment<E>> segments) {
        this.segments.addAll(segments);
        this.catalyst = catalyst;
    }

    public int size() {
        return this.segments.size();
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public Segment<E> remove() {
        return this.segments.removeFirst();
    }

    public Collection<Segment<E>> remaining() {
        LinkedList<Segment<E>> remaining = this.segments;
        this.segments = new LinkedList();
        return remaining;
    }

    public <T> Segments<T> from(DataSet<T> dataSet) {
        return this.dependents.computeIfAbsent(dataSet, d -> d.segment(this.catalyst));
    }

    public <T> Collection<Segment<T>> segment(DataSet<T> dataSet) {
        Segments<T> mySegments = this.from(dataSet);
        ArrayList<Segment<T>> s = new ArrayList<Segment<T>>();
        if (this.isEmpty()) {
            s.addAll(mySegments.remaining());
        } else if (!mySegments.isEmpty()) {
            s.add(mySegments.remove());
        }
        return s;
    }
}

