/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.messaging;

import akka.actor.PoisonPill;
import akka.actor.Status;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.PostStop;
import akka.actor.typed.javadsl.Adapter;
import akka.actor.typed.javadsl.Behaviors;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.messaging.Destination;
import net.e6tech.elements.network.cluster.messaging.MessagingEvents;
import net.e6tech.elements.network.cluster.messaging.SubscriberActor;

public class Messenger
extends CommonBehavior<Messenger, MessagingEvents> {
    private static final String SUBSCRIBER_PREFIX = "subscriber-";
    private static final String DESTINATION_PREFIX = "destination-";
    private akka.actor.ActorRef mediator;
    private Map<String, Map<Subscriber, ActorRef>> subscribers = new HashMap<String, Map<Subscriber, ActorRef>>();
    private Map<String, ActorRef> destinations = new HashMap<String, ActorRef>();

    public void initialize() {
        this.mediator = DistributedPubSub.lookup().get(this.untypedContext().system()).mediator();
    }

    @Typed
    private void postStop(PostStop postStop) {
        for (Map<Subscriber, ActorRef> map : this.subscribers.values()) {
            for (ActorRef ref : map.values()) {
                ref.tell((Object)PoisonPill.getInstance());
            }
        }
        this.subscribers.clear();
        for (ActorRef ref : this.destinations.values()) {
            ref.tell((Object)PoisonPill.getInstance());
        }
        this.destinations.clear();
    }

    @Typed
    private void subscribe(MessagingEvents.Subscribe event) {
        Map map = this.subscribers.computeIfAbsent(event.topic, topic -> new HashMap());
        map.computeIfAbsent(event.subscriber, sub -> this.childActor(new SubscriberActor(event.topic, event.subscriber)).withName(SUBSCRIBER_PREFIX + event.topic + System.identityHashCode(event.subscriber)).spawn());
    }

    @Typed
    private void unsubscribe(MessagingEvents.Unsubscribe event) {
        ActorRef child;
        Map<Subscriber, ActorRef> map = this.subscribers.get(event.topic);
        if (map != null && (child = map.get(event.subscriber)) != null) {
            this.mediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(event.topic, Adapter.toUntyped((ActorRef)child)), this.untypedRef());
            child.tell((Object)PoisonPill.getInstance());
            map.remove(event.subscriber);
        }
    }

    @Typed
    private Behavior<MessagingEvents> newDestination(MessagingEvents.NewDestination event) {
        if (this.destinations.get(event.destination) != null) {
            event.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")));
        } else {
            ActorRef dest = this.childActor(new Destination(event.subscriber)).withName(DESTINATION_PREFIX + event.destination).spawn();
            this.destinations.put(event.destination, dest);
        }
        return Behaviors.same();
    }

    @Typed
    private void removeDestination(MessagingEvents.RemoveDestination event) {
        ActorRef child = this.destinations.get(event.destination);
        if (child != null) {
            this.mediator.tell((Object)new DistributedPubSubMediator.Remove(child.path().name()), this.untypedRef());
            child.tell((Object)PoisonPill.getInstance());
            this.destinations.remove("/user/" + this.getSelf().path().name() + "/" + DESTINATION_PREFIX + event.destination);
        }
    }

    @Typed
    private void publish(MessagingEvents.Publish event) {
        this.mediator.tell((Object)new DistributedPubSubMediator.Publish(event.getTopic(), (Object)event), this.untypedRef());
    }

    @Typed
    private void send(MessagingEvents.Send event) {
        this.mediator.tell((Object)new DistributedPubSubMediator.Send("/user/" + this.getSelf().path().name() + "/" + DESTINATION_PREFIX + event.destination, (Object)event, true), this.untypedRef());
    }
}

