/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.messaging;

import akka.actor.typed.ActorRef;
import java.io.Serializable;
import net.e6tech.elements.common.subscribe.Subscriber;

public interface MessagingEvents
extends Serializable {

    public static class Send
    implements MessagingEvents {
        private static final long serialVersionUID = -2800137846339616601L;
        String destination;
        Object message;

        public Send(String destination, Object message) {
            this.destination = destination;
            this.message = message;
        }

        public String getDestination() {
            return this.destination;
        }

        public Object getMessage() {
            return this.message;
        }
    }

    public static class Publish
    implements MessagingEvents {
        private static final long serialVersionUID = 3634267916819024147L;
        String topic;
        Object message;

        public Publish(String topic, Object message) {
            this.topic = topic;
            this.message = message;
        }

        public String getTopic() {
            return this.topic;
        }

        public Object getMessage() {
            return this.message;
        }
    }

    public static class RemoveDestination
    implements MessagingEvents {
        private static final long serialVersionUID = -8552636627374108324L;
        String destination;

        public RemoveDestination(String destination) {
            this.destination = destination;
        }

        public String getDestination() {
            return this.destination;
        }
    }

    public static class NewDestination
    implements MessagingEvents {
        private static final long serialVersionUID = -227499564362523104L;
        String destination;
        Subscriber subscriber;
        ActorRef sender;

        public NewDestination(ActorRef sender, String destination, Subscriber subscriber) {
            this.sender = sender;
            this.destination = destination;
            this.subscriber = subscriber;
        }

        public String getDestination() {
            return this.destination;
        }

        public Subscriber getSubscriber() {
            return this.subscriber;
        }

        public ActorRef getSender() {
            return this.sender;
        }
    }

    public static class Unsubscribe
    implements MessagingEvents {
        private static final long serialVersionUID = 5224795221846176188L;
        String topic;
        Subscriber subscriber;

        public Unsubscribe() {
        }

        public Unsubscribe(String topic, Subscriber subscriber) {
            this.topic = topic;
            this.subscriber = subscriber;
        }

        public String getTopic() {
            return this.topic;
        }

        public Subscriber getSubscriber() {
            return this.subscriber;
        }
    }

    public static class Subscribe
    implements MessagingEvents {
        private static final long serialVersionUID = 7295040545418105218L;
        String topic;
        Subscriber subscriber;

        public Subscribe() {
        }

        public Subscribe(String topic, Subscriber subscriber) {
            this.topic = topic;
            this.subscriber = subscriber;
        }

        public String getTopic() {
            return this.topic;
        }

        public Subscriber getSubscriber() {
            return this.subscriber;
        }
    }
}

