/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.messaging;

import akka.actor.ActorRef;
import akka.actor.typed.DispatcherSelector;
import akka.actor.typed.javadsl.Behaviors;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.japi.function.Function2;
import java.io.Serializable;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.messaging.MessagingEvents;

public class Destination
extends CommonBehavior<Destination, MessagingEvents> {
    private Subscriber subscriber;

    public Destination(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void initialize() {
        ActorRef mediator = DistributedPubSub.lookup().get(this.untypedContext().system()).mediator();
        mediator.tell((Object)new DistributedPubSubMediator.Put(this.untypedRef()), this.untypedRef());
        this.getContext().spawnAnonymous(Behaviors.receive(DistributedPubSubMediator.SubscribeAck.class).onMessage(DistributedPubSubMediator.SubscribeAck.class, (Function2 & Serializable)(ctx, msg) -> {
            ctx.getSystem().log().info("subscribing to " + msg.toString());
            return Behaviors.same();
        }).build());
    }

    @Typed
    private void send(MessagingEvents.Send send) {
        this.getContext().getSystem().dispatchers().lookup(DispatcherSelector.defaultDispatcher()).execute(() -> this.subscriber.receive(new Notice(send.destination, (Serializable)send.message)));
    }
}

