/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.legacy;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Status;
import akka.actor.typed.javadsl.Adapter;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.network.cluster.legacy.Events;
import net.e6tech.elements.network.cluster.legacy.RegistryImpl;

class RegistryEntryActor
extends AbstractActor {
    LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    Cluster cluster = Cluster.lookup().get(this.getContext().system());
    Events.Registration registration;
    Guardian guardian;

    public RegistryEntryActor(Guardian guardian, Events.Registration registration) {
        this.registration = registration;
        this.guardian = guardian;
    }

    public void preStart() {
        this.cluster.subscribe(this.getSelf(), new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.UnreachableMember.class});
        this.getContext().getParent().tell((Object)new Events.Announcement(this.registration), this.getSelf());
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ClusterEvent.MemberUp.class, member -> this.register(member.member())).match(ClusterEvent.CurrentClusterState.class, state -> {
            for (Member member : state.getMembers()) {
                if (!member.status().equals(MemberStatus.up())) continue;
                this.register(member);
            }
        }).match(ClusterEvent.UnreachableMember.class, member -> this.log.info("Member detected as unreachable: {}", (Object)member.member())).match(ClusterEvent.MemberRemoved.class, member -> this.log.info("Member is Removed: {}", (Object)member.member())).match(Events.Invocation.class, message -> {
            ActorRef sender = this.getSender();
            ActorRef self = this.getSelf();
            try {
                this.guardian.async(() -> {
                    try {
                        Object ret = this.registration.function().apply(Adapter.toTyped((ActorRef)self), message.arguments());
                        sender.tell((Object)new Events.Response(ret, self), self);
                    }
                    catch (Exception ex) {
                        sender.tell((Object)new Status.Failure((Throwable)ex), self);
                    }
                }, message.getTimeout());
            }
            catch (RuntimeException ex) {
                Throwable throwable = ex.getCause();
                if (throwable == null) {
                    throwable = ex;
                }
                sender.tell((Object)new Status.Failure(throwable), self);
            }
        }).build();
    }

    void register(Member member) {
        if (!this.cluster.selfAddress().equals((Object)member.address())) {
            this.getContext().actorSelection(member.address() + "/user/" + RegistryImpl.getPath()).tell((Object)new Events.Announcement(this.registration), this.getSelf());
        }
    }
}

