/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.typed.ActorRef;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Guardian;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.AsyncImpl;
import net.e6tech.elements.network.cluster.ClusterAsync;
import net.e6tech.elements.network.cluster.RouteListener;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;
import net.e6tech.elements.network.cluster.invocation.Invoker;
import net.e6tech.elements.network.cluster.invocation.Local;
import net.e6tech.elements.network.cluster.invocation.Registrar;
import net.e6tech.elements.network.cluster.invocation.Registry;
import scala.concurrent.ExecutionContextExecutor;

public class RegistryImpl
implements Registry {
    private static String path = "registry";
    public static final String REGISTRY_DISPATCHER = "registry-dispatcher";
    private Guardian guardian;
    private Registrar registrar;
    private ExecutionContextExecutor dispatcher;
    private long timeout = 10000L;
    private List<RouteListener> listeners = Collections.synchronizedList(new ArrayList());

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        RegistryImpl.path = path;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.dispatcher.execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.dispatcher.execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    @Override
    public void start(Guardian guardian) {
        this.guardian = guardian;
        this.dispatcher = guardian.getContext().getExecutionContext();
        this.registrar = new Registrar(this);
        guardian.childActor((CommonBehavior)this.registrar).withName(RegistryImpl.getPath()).spawn();
    }

    @Override
    public void shutdown() {
        this.registrar.stop();
    }

    @Override
    public Collection routes(String path) {
        try {
            InvocationEvents.Response response = (InvocationEvents.Response)this.registrar.ask(ref -> new InvocationEvents.Routes((ActorRef)ref, path), this.timeout).toCompletableFuture().get();
            return (Collection)response.getValue();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Override
    public Collection routes(String qualifier, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            String p = this.fullyQualify(qualifier, interfaceClass, method);
            return this.routes(p);
        }
        return Collections.emptyList();
    }

    @Override
    public <R, U> CompletionStage<U> register(String path, BiFunction<ActorRef, Object[], R> function) {
        return this.registrar.ask(ref -> new InvocationEvents.Registration((ActorRef)ref, path, function), this.timeout);
    }

    @Override
    public <T, U> CompletionStage<List<U>> register(String qualifier, Class<T> interfaceClass, T implementation) {
        return this.register(qualifier, interfaceClass, implementation, null);
    }

    @Override
    public <T, U> CompletionStage<List<U>> register(String qualifier, Class<T> interfaceClass, T implementation, Invoker customizedInvoker) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        ArrayList list = new ArrayList();
        for (Method method : interfaceClass.getMethods()) {
            String methodName;
            Local local = method.getAnnotation(Local.class);
            if (local != null || "hashCode".equals(methodName = method.getName()) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            if (customizedInvoker == null) {
                customizedInvoker = new Invoker();
            }
            Invoker invoker = customizedInvoker;
            list.add(this.register(this.fullyQualify(qualifier, interfaceClass, method), (actor, args) -> invoker.invoke((ActorRef)actor, implementation, method, (Object[])args)).toCompletableFuture());
        }
        return CompletableFuture.supplyAsync(() -> {
            ArrayList results = new ArrayList();
            for (CompletableFuture stage : list) {
                try {
                    results.add(stage.get(this.getTimeout(), TimeUnit.MILLISECONDS));
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            }
            return results;
        });
    }

    String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        String normalizedQualifier;
        StringBuilder builder = new StringBuilder();
        String string = normalizedQualifier = qualifier == null ? "" : qualifier.trim();
        if (normalizedQualifier.length() > 0) {
            builder.append(normalizedQualifier);
            builder.append("@");
        }
        builder.append(interfaceClass.getName());
        builder.append("::");
        builder.append(method.getName());
        boolean first = true;
        for (Class<?> param : method.getParameterTypes()) {
            if (first) {
                first = false;
                builder.append("+");
            } else {
                builder.append(",");
            }
            builder.append(param.getTypeName());
        }
        return builder.toString();
    }

    @Override
    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String qualifier, Class interfaceClass, Method method, long timeout) {
        return this.route(this.fullyQualify(qualifier, interfaceClass, method), timeout);
    }

    @Override
    public Function<Object[], CompletionStage<InvocationEvents.Response>> route(String path, long timeout) {
        return arguments -> this.registrar.ask(ref -> new InvocationEvents.Request((ActorRef<InvocationEvents.Response>)ref, path, timeout, (Object[])arguments), timeout);
    }

    @Override
    public <T> ClusterAsync<T> async(String qualifier, Class<T> interfaceClass) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, this.getTimeout());
    }

    @Override
    public <T> ClusterAsync<T> async(String qualifier, Class<T> interfaceClass, long timeout) {
        return new AsyncImpl<T>(this, qualifier, interfaceClass, timeout);
    }
}

