/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.Address;
import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.PostStop;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.Behaviors;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.cluster.typed.Cluster;
import akka.cluster.typed.Subscribe;
import akka.cluster.typed.Unsubscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.actor.Genesis;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.inject.Inject;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.MemberListener;
import net.e6tech.elements.network.cluster.invocation.Registry;
import net.e6tech.elements.network.cluster.invocation.RegistryImpl;
import net.e6tech.elements.network.cluster.messaging.Messaging;

public class ClusterNode
implements Initializable {
    public static final long DEFAULT_TIME_OUT = 10000L;
    private String name;
    private String configuration;
    private Genesis genesis;
    private ActorRef<ClusterEvent.ClusterDomainEvent> membership;
    private Map<Address, Member> members = new HashMap<Address, Member>();
    private Messaging broadcast;
    private Registry registry;
    private Class<? extends Registry> registryClass;
    private List<MemberListener> memberListeners = new ArrayList<MemberListener>();
    private boolean started = false;
    private long timeout = 10000L;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (this.broadcast != null) {
            this.broadcast.setTimeout(timeout);
        }
        if (this.registry != null) {
            this.registry.setTimeout(timeout);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Genesis getGenesis() {
        return this.genesis;
    }

    @Inject(optional=true)
    public void setGenesis(Genesis genesis) {
        this.genesis = genesis;
    }

    public Broadcast getBroadcast() {
        return this.broadcast;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Map<Address, Member> getMembers() {
        return this.members;
    }

    public Class<? extends Registry> getRegistryClass() {
        return this.registryClass;
    }

    public void setRegistryClass(Class<? extends Registry> registryClass) {
        this.registryClass = registryClass;
    }

    public void initialize(Resources resources) {
        if (this.genesis == null) {
            this.genesis = new Genesis();
            this.genesis.setName(this.getName());
            this.genesis.setConfiguration(this.getConfiguration());
            this.genesis.setTimeout(this.getTimeout());
            this.genesis.initialize(resources);
        }
        this.initialize(this.genesis);
    }

    public void initialize(Genesis genesis) {
        this.genesis = genesis;
        this.setName(genesis.getName());
        this.setTimeout(genesis.getTimeout());
        this.setConfiguration(genesis.getConfiguration());
        this.start();
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (this.membership == null) {
            this.membership = this.genesis.getGuardian().childActor((CommonBehavior)new Membership()).spawn();
        }
        if (this.broadcast == null) {
            this.broadcast = new Messaging();
            this.broadcast.setTimeout(this.timeout);
        }
        if (this.registry == null) {
            Class<? extends Registry> rc = this.getRegistryClass();
            if (rc == null) {
                rc = RegistryImpl.class;
            }
            try {
                this.registry = rc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            this.registry.setTimeout(this.timeout);
        }
        this.broadcast.start(this.genesis.getGuardian());
        this.registry.start(this.genesis.getGuardian());
        this.started = true;
    }

    public void shutdown() {
        this.genesis.getGuardian().stop(this.membership);
        this.broadcast.shutdown();
        this.registry.shutdown();
        this.genesis.terminate();
        this.members.clear();
        this.started = false;
    }

    class Membership
    extends CommonBehavior<Membership, ClusterEvent.ClusterDomainEvent> {
        Cluster cluster;

        Membership() {
        }

        public void initialize() {
            this.cluster = Cluster.get((ActorSystem)this.getContext().getSystem());
            this.cluster.subscriptions().tell((Object)new Subscribe(this.getContext().getSelf(), ClusterEvent.ClusterDomainEvent.class));
        }

        @Typed
        void memberUp(ClusterEvent.MemberUp member) {
            ClusterNode.this.members.put(member.member().address(), member.member());
            ClusterNode.this.memberListeners.forEach(listener -> listener.memberUp(member.member().address().toString()));
        }

        @Typed
        void currentState(ClusterEvent.CurrentClusterState state) {
            for (Member member : state.getMembers()) {
                if (!member.status().equals(MemberStatus.up())) continue;
                ClusterNode.this.members.put(member.address(), member);
                ClusterNode.this.memberListeners.forEach(listener -> listener.memberUp(member.address().toString()));
            }
        }

        @Typed
        void removed(ClusterEvent.MemberRemoved member) {
            ClusterNode.this.members.remove(member.member().address());
            ClusterNode.this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
        }

        @Typed
        void unreachable(ClusterEvent.UnreachableMember member) {
            ClusterNode.this.members.remove(member.member().address());
            ClusterNode.this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
        }

        @Typed
        public void postStop(PostStop postStop) {
            this.cluster.subscriptions().tell((Object)new Unsubscribe(this.getContext().getSelf()));
        }

        @Typed
        public Behavior<ClusterEvent.ClusterDomainEvent> terminated(Terminated terminated) {
            return Behaviors.stopped();
        }
    }
}

