/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.invocation;

import akka.actor.Status;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.DispatcherSelector;
import akka.actor.typed.Props;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.GroupRouter;
import akka.actor.typed.javadsl.Routers;
import akka.actor.typed.receptionist.Receptionist;
import akka.actor.typed.receptionist.ServiceKey;
import akka.japi.function.Function;
import akka.japi.function.Function2;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.e6tech.elements.common.actor.typed.CommonBehavior;
import net.e6tech.elements.common.actor.typed.Typed;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.network.cluster.invocation.InvocationEvents;
import net.e6tech.elements.network.cluster.invocation.RegistryEntry;
import net.e6tech.elements.network.cluster.invocation.RegistryImpl;
import scala.concurrent.ExecutionContextExecutor;

public class Registrar
extends CommonBehavior<Registrar, InvocationEvents> {
    private Map<String, ActorRef<InvocationEvents.Request>> routes = new HashMap<String, ActorRef<InvocationEvents.Request>>();
    private Map<String, Set<ActorRef<InvocationEvents.Request>>> actors = new ConcurrentHashMap<String, Set<ActorRef<InvocationEvents.Request>>>();
    private Map<ActorRef<InvocationEvents.Request>, String> actorKeys = new ConcurrentHashMap<ActorRef<InvocationEvents.Request>, String>();
    private RegistryImpl registry;

    public Registrar(RegistryImpl registry) {
        this.registry = registry;
    }

    @Typed
    private void registration(InvocationEvents.Registration registration) {
        ExecutionContextExecutor executor = this.getContext().getSystem().dispatchers().lookup(DispatcherSelector.fromConfig((String)"registry-dispatcher"));
        String dispatcher = executor != null ? "registry-dispatcher" : "worker-pool-dispatcher";
        ServiceKey key = ServiceKey.create(InvocationEvents.Request.class, (String)registration.getPath());
        this.getContext().spawnAnonymous(Behaviors.setup((Function & Serializable)ctx -> {
            ctx.getSystem().receptionist().tell((Object)Receptionist.subscribe((ServiceKey)key, (ActorRef)ctx.getSelf().narrow()));
            return Behaviors.receive(Object.class).onMessage(Receptionist.Listing.class, (Function2 & Serializable)(c, msg) -> {
                Set set = this.actors.getOrDefault(registration.getPath(), Collections.emptySet());
                for (ActorRef ref : msg.getServiceInstances(key)) {
                    if (set.contains(ref)) continue;
                    this.getContext().watch(ref);
                    this.actorKeys.put((ActorRef<InvocationEvents.Request>)ref, registration.getPath());
                    this.registry.onAnnouncement(registration.getPath());
                }
                this.actors.put(registration.getPath(), new LinkedHashSet(msg.getServiceInstances(key)));
                return Behaviors.same();
            }).build();
        }));
        this.childActor(new RegistryEntry(registration)).withProps((Props)DispatcherSelector.fromConfig((String)dispatcher)).whenSetup((ctx, child) -> this.getSystem().receptionist().tell((Object)Receptionist.register((ServiceKey)key, (ActorRef)child.getSelf()))).spawn();
        this.routes.computeIfAbsent(registration.getPath(), k -> {
            GroupRouter g = Routers.group((ServiceKey)key).withRoundRobinRouting();
            return this.getContext().spawnAnonymous((Behavior)g);
        });
    }

    @Typed
    private void request(InvocationEvents.Request request) {
        ActorRef<InvocationEvents.Request> router = this.routes.get(request.getPath());
        if (router == null) {
            request.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")));
        } else {
            router.tell((Object)request);
        }
    }

    @Typed
    private void terminated(Terminated terminated) {
        Set<ActorRef<InvocationEvents.Request>> set;
        ActorRef actor = terminated.getRef();
        String key = this.actorKeys.get(actor);
        if (key != null && (set = this.actors.get(key)) != null) {
            set.remove(actor);
            this.registry.onTerminated(key, actor);
        }
    }

    @Typed
    private void routes(InvocationEvents.Routes message) {
        Set<ActorRef<InvocationEvents.Request>> actorsForKey = this.actors.get(message.getPath());
        if (actorsForKey == null) {
            message.getSender().tell((Object)new InvocationEvents.Response(this.getSelf(), Collections.emptySet()));
        } else {
            message.getSender().tell((Object)new InvocationEvents.Response(this.getSelf(), actorsForKey));
        }
    }
}

