/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Gatherer;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.dataset.CollectionDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;
import net.e6tech.elements.network.cluster.catalyst.transform.Transform;

public class Series<Re extends Reactor, T, R>
implements Serializable,
Cloneable,
Function<Re, Collection<R>> {
    private static final long serialVersionUID = 5420350641543073437L;
    protected Segment<T> segment;
    protected List<Transform> transforms = new ArrayList<Transform>();

    public static <Re extends Reactor, I, O> Series<Re, I, O> from(Transform<Re, I, O> transform) {
        Series t = new Series();
        return t.add(transform);
    }

    @Override
    public Collection<R> apply(Reactor reactor) {
        Stream<Object> stream = this.segment.stream(reactor);
        this.segment = null;
        for (Transform transform : this.transforms) {
            Stream tmp = transform.transform(reactor, stream);
            stream = tmp;
        }
        return this.collect(stream);
    }

    protected Collection<R> collect(Stream<R> stream) {
        return stream.collect(Collectors.toList());
    }

    public Gatherer<R> gatherer() {
        return new Gatherer();
    }

    public <U> Series<Re, T, U> add(Transform<Re, R, U> transform) {
        this.transforms.add(transform);
        return this;
    }

    public Series<Re, T, R> clone() {
        try {
            return (Series)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Series<Re, T, R> allocate(Segments<T> segments) {
        Object copy = this.clone();
        ((Series)copy).segment = segments.remove();
        ((Series)copy).transforms = new ArrayList<Transform>();
        for (Transform t : this.transforms) {
            Transform p = t.allocate(segments);
            ((Series)copy).transforms.add(p);
        }
        return copy;
    }

    public DataSet<R> transform(Catalyst<Re> catalyst, DataSet<T> dataSet) {
        return new CollectionDataSet(catalyst.transform(this, dataSet));
    }
}

