/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.scalar;

import java.io.Serializable;
import java.util.Collection;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.scalar.Scalar;

public class Reduce<Re extends Reactor, T, R>
extends Scalar<Re, T, R, R> {
    private static final long serialVersionUID = 2541978434272522759L;
    private transient ReduceOp<R> reduceOp;

    public Reduce() {
    }

    public Reduce(ReduceOp<R> reduce) {
        this.setMapping((reactor, collection) -> reduce.reduce((Collection)collection));
    }

    @FunctionalInterface
    public static interface ReduceOp<R>
    extends Serializable {
        default public R reduce(Collection<R> collection) {
            Object accumulator = null;
            boolean first = true;
            for (R r : collection) {
                if (r == null) continue;
                if (first) {
                    first = false;
                    accumulator = r;
                    continue;
                }
                accumulator = this.reduce(accumulator, r);
            }
            return accumulator;
        }

        public R reduce(R var1, R var2);
    }
}

