/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;

public class SplitDataSet<E>
implements DataSet<E> {
    private List<Segment<E>> segments = new ArrayList<Segment<E>>();

    public SplitDataSet() {
    }

    public SplitDataSet(Collection<Collection<E>> segments) {
        this.addAll(segments);
    }

    public SplitDataSet(Collection<E> entries, Function<E, Object> keyFunc) {
        HashMap<Object, Collection> map = new HashMap<Object, Collection>(entries.size());
        for (E e : entries) {
            Collection list = map.computeIfAbsent(keyFunc.apply(e), key -> new ArrayList());
            list.add(e);
        }
        this.addAll(map.values());
    }

    public SplitDataSet(Function<E, Object> keyFunc, E ... entries) {
        if (entries != null) {
            HashMap<Object, Collection> map = new HashMap<Object, Collection>(entries.length);
            for (E e : entries) {
                Collection list = map.computeIfAbsent(keyFunc.apply(e), key -> new ArrayList());
                list.add(e);
            }
            this.addAll(map.values());
        }
    }

    public SplitDataSet<E> add(Collection<E> collection) {
        this.segments.add(reactor -> collection.stream());
        return this;
    }

    public SplitDataSet<E> addAll(Collection<Collection<E>> segments) {
        if (this.segments.size() == 0) {
            this.segments = new ArrayList<Segment<E>>(segments.size());
        }
        for (Collection<E> c : segments) {
            this.add(c);
        }
        return this;
    }

    @Override
    public Segments<E> segment(Catalyst catalyst) {
        return new Segments<E>(catalyst, this.segments);
    }

    @Override
    public Collection<E> asCollection() {
        return Collections.emptyList();
    }
}

