/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;

public class CollectionDataSet<E>
implements DataSet<E> {
    private List<Segment<E>> segments = new ArrayList<Segment<E>>();
    private Collection<E> dataSet;
    private int splitFactor = 1;

    public CollectionDataSet(E ... entries) {
        this.dataSet = entries != null ? Arrays.asList(entries) : new ArrayList();
    }

    public CollectionDataSet(Collection<E> dataSet) {
        this.dataSet = dataSet;
    }

    public CollectionDataSet(Collection<E> dataSet, int splitFactor) {
        this.dataSet = dataSet;
        this.splitFactor = splitFactor;
    }

    @Override
    public Segments<E> segment(Catalyst catalyst) {
        int routes = catalyst.getRegistry().routes(catalyst.getQualifier(), Reactor.class).size();
        int split = 0;
        if (routes > 1) {
            double ln = Math.log(routes) / Math.log(2.0);
            int whole = (int)ln;
            if (Math.pow(2.0, ln) - Math.pow(2.0, whole) > (double)whole * 0.2) {
                ++whole;
            }
            split = whole + this.splitFactor;
        }
        ArrayList<Spliterator> tmp = new ArrayList<Spliterator>();
        Spliterator<E> spliterator = this.dataSet.spliterator();
        ArrayList<Spliterator> spliterators = new ArrayList<Spliterator>();
        spliterators.add(spliterator);
        for (int i = 0; i < split; ++i) {
            tmp.clear();
            for (Spliterator segment : spliterators) {
                Spliterator second = segment.trySplit();
                if (second != null) {
                    tmp.add(second);
                }
                tmp.add(segment);
            }
            spliterators.clear();
            spliterators.addAll(tmp);
        }
        this.segments.clear();
        for (Spliterator s : spliterators) {
            List list = StreamSupport.stream(s, false).collect(Collectors.toList());
            this.segments.add(reactor -> list.stream());
        }
        return new Segments<E>(catalyst, this.segments);
    }

    @Override
    public Collection<E> asCollection() {
        return this.dataSet;
    }
}

