/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.restful;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.serialization.ObjectMapperFactory;
import net.e6tech.elements.common.util.ErrorResponse;
import net.e6tech.elements.network.restful.Marshaller;

public class JsonMarshaller
implements Marshaller {
    public static final ObjectMapper mapper = ObjectMapperFactory.newInstance();

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getAccept() {
        return "application/json";
    }

    @Override
    public String prettyPrintRequest(Object data) throws Exception {
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(data);
    }

    @Override
    public String encodeRequest(Object data) throws Exception {
        return mapper.writeValueAsString(data);
    }

    @Override
    public String prettyPrintResponse(String response) throws Exception {
        if (response != null && response.length() > 0) {
            Object ret = response.startsWith("[") ? mapper.readValue(response, List.class) : (response.startsWith("{") ? mapper.readValue(response, Map.class) : (response.startsWith("\"") ? mapper.readValue(response, String.class) : (Character.isDigit(response.charAt(0)) ? (response.contains(".") ? mapper.readValue(response, BigDecimal.class) : mapper.readValue(response, Long.class)) : ("true".equalsIgnoreCase(response) || "false".equalsIgnoreCase(response) ? Boolean.valueOf(Boolean.getBoolean(response)) : response))));
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(ret);
        }
        return "";
    }

    @Override
    public ErrorResponse readErrorResponse(String errorResponse) throws Exception {
        return (ErrorResponse)mapper.readValue(errorResponse, ErrorResponse.class);
    }
}

