/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.network.cluster.ClusterAsync;
import net.e6tech.elements.network.cluster.Registry;
import net.e6tech.elements.network.cluster.catalyst.Builder;
import net.e6tech.elements.network.cluster.catalyst.Gatherer;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.dataset.CollectionDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.RemoteDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;
import net.e6tech.elements.network.cluster.catalyst.scalar.Scalar;
import net.e6tech.elements.network.cluster.catalyst.transform.Series;

public class Catalyst<Re extends Reactor> {
    private Registry registry;
    private long waitTime = 20000L;
    private String qualifier = "";
    private Class<Re> reactorClass;

    public Catalyst(String qualifier, Class<Re> reactorClass, Registry registry) {
        this.qualifier = qualifier;
        this.registry = registry;
        this.reactorClass = reactorClass;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public <T> Builder<Re, T, T> builder(DataSet<T> dataSet) {
        return new Builder(this, dataSet);
    }

    public <T> Builder<Re, T, T> builder(Series<Re, T, T> series, DataSet<T> dataSet) {
        return new Builder(this, series, dataSet);
    }

    public <T, R, U> U scalar(Scalar<Re, T, R, U> scalar, DataSet<T> dataSet) {
        Object copy;
        Collection<U> result = this.collect(scalar, dataSet);
        ClusterAsync<Re> async = this.registry.async(this.qualifier, this.reactorClass, this.waitTime);
        Series emptySeries = new Series();
        try {
            copy = scalar.clone();
            ((Scalar)copy).setSeries(emptySeries.allocate(new CollectionDataSet<U>(result).segment(this)));
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        return (U)async.apply(arg_0 -> Catalyst.lambda$scalar$0((Scalar)copy, arg_0)).toCompletableFuture().join();
    }

    public <T, R, U> Collection<U> collect(Scalar<Re, T, R, U> scalar, DataSet<T> dataSet) {
        List workLoad = this.prepareWork(dataSet, segments -> {
            try {
                Object copy = scalar.clone();
                ((Scalar)copy).setSeries(scalar.getSeries().allocate(segments));
                return copy;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        });
        ArrayList result = new ArrayList();
        for (Work work : workLoad) {
            work.start();
        }
        for (Work work : workLoad) {
            result.add(work.value());
        }
        return result;
    }

    public void run(Runnable ... runnables) {
        RemoteDataSet dataSet = new RemoteDataSet();
        for (Runnable runnable : runnables) {
            dataSet.add(reactor -> {
                runnable.run();
                return Collections.EMPTY_LIST.stream();
            });
        }
        this.transform(new Series(), dataSet);
    }

    public <T, R> Collection<R> transform(Series<Re, T, R> series, DataSet<T> dataSet) {
        List workLoad = this.prepareWork(dataSet, segments -> series.allocate((Segments)segments));
        for (Work work : workLoad) {
            work.start();
        }
        Gatherer<R> gatherer = series.gatherer();
        for (Work work : workLoad) {
            gatherer.gather((Collection)work.value());
        }
        return gatherer.collection;
    }

    private <T, O> List<Work<T, O>> prepareWork(DataSet<T> dataSet, Function<Segments<T>, Function<? extends Reactor, O>> work) {
        Segments<T> segments = dataSet.segment(this);
        ArrayList<Work<T, O>> workLoad = new ArrayList<Work<T, O>>();
        for (int i = 0; i < segments.size(); ++i) {
            workLoad.add(new Work(this.registry.async(this.qualifier, this.reactorClass, this.waitTime), segments, work));
        }
        return workLoad;
    }

    private static /* synthetic */ Object lambda$scalar$0(Scalar copy, Reactor p) {
        return p.apply(copy);
    }

    private static class Work<T, R> {
        Async<Reactor> async;
        Segments<T> segments;
        CompletableFuture<R> future;
        Function<Segments<T>, Function<? extends Reactor, R>> work;
        Function<? extends Reactor, R> function;

        Work(Async<Reactor> async, Segments<T> segments, Function<Segments<T>, Function<? extends Reactor, R>> work) {
            this.async = async;
            this.segments = segments;
            this.work = work;
        }

        void start() {
            if (this.function == null) {
                this.function = this.work.apply(this.segments);
            }
            this.future = this.async.apply(reactor -> reactor.apply(this.function)).toCompletableFuture();
        }

        R value() {
            try {
                return this.future.join();
            }
            catch (Exception ex) {
                this.start();
                return this.future.join();
            }
        }
    }
}

