/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.catalyst.Mapping;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Series;

public class Scalar<Re extends Reactor, T, R>
implements Cloneable,
Function<Re, R>,
Serializable {
    private static final long serialVersionUID = 1676649613567136786L;
    private Series<Re, T, R> series;
    private Mapping<Re, Collection<R>, R> mapping;

    public Scalar() {
    }

    public Scalar(Mapping<Re, Collection<R>, R> mapping) {
        this.setMapping(mapping);
    }

    @Override
    public R apply(Re reactor) {
        Series<Re, Re, R> t = this.series;
        Collection collection = (Collection)t.apply(reactor);
        Mapping<Re, Collection<R>, R> m = this.mapping;
        return m.apply(reactor, collection);
    }

    public Scalar<Re, T, R> clone() {
        try {
            return (Scalar)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Series<Re, T, R> getSeries() {
        return this.series;
    }

    public void setSeries(Series<Re, T, R> series) {
        this.series = series;
    }

    public Mapping<Re, Collection<R>, R> getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping<Re, Collection<R>, R> mapping) {
        this.mapping = mapping;
    }
}

