/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Scalar;
import net.e6tech.elements.network.cluster.catalyst.Series;
import net.e6tech.elements.network.cluster.catalyst.dataset.CollectionDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.transform.Transform;

public class Builder<Re extends Reactor, T, R> {
    private Catalyst<Re> catalyst;
    private DataSet<T> dataSet;
    private Series<Re, T, R> series = new Series();

    public Builder(Catalyst<Re> catalyst, DataSet<T> dataSet) {
        this.catalyst = catalyst;
        this.dataSet = dataSet;
    }

    public Builder(Catalyst<Re> catalyst, Series<Re, T, T> series, DataSet<T> dataSet) {
        this.catalyst = catalyst;
        this.series = series;
        this.dataSet = dataSet;
    }

    public <U> Builder<Re, T, U> add(Transform<Re, R, U> transform) {
        this.series = this.series.add(transform);
        return this;
    }

    public DataSet<R> transform() {
        return new CollectionDataSet<R>(this.catalyst.transform(this.series, this.dataSet));
    }

    public R scalar(Scalar<Re, T, R> scalar) {
        scalar.setSeries(this.series);
        return this.catalyst.scalar(scalar, this.dataSet);
    }
}

