/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Mapping;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Series;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;

public class Scalar<Re extends Reactor, T, R>
implements Function<Re, R>,
Serializable {
    private static final long serialVersionUID = 1676649613567136786L;
    private Series<Re, T, R> series;
    private Mapping<Re, Collection<R>, R> mapping;

    public Scalar(Series<Re, T, R> series, Mapping<Re, Collection<R>, R> mapping) {
        this.series = series;
        this.mapping = mapping;
    }

    @Override
    public R apply(Re reactor) {
        Series<Re, Re, R> t = this.series;
        Collection collection = (Collection)t.apply(reactor);
        Mapping<Re, Collection<R>, R> m = this.mapping;
        return m.apply(reactor, collection);
    }

    public R scalar(Catalyst<Re> catalyst, DataSet<T> dataSet) {
        Mapping<Re, Collection<R>, R> m = this.mapping;
        return catalyst.scalar(dataSet, this.series, m);
    }
}

