/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.Collection;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Series;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;

public class Reduce<Re extends Reactor, T, R>
extends Series<Re, T, R> {
    public Reduce() {
    }

    public Reduce(Series<Re, T, R> other) {
        super(other);
    }

    public R reduce(Catalyst<Re> catalyst, DataSet<T> dataSet, ReduceOp<R> reduce) {
        Collection result = catalyst.collect(dataSet, this, (reactor, collection) -> reduce.reduce((Collection)collection));
        return reduce.reduce(result);
    }

    @FunctionalInterface
    public static interface ReduceOp<T>
    extends Serializable {
        default public T reduce(Collection<T> collection) {
            Object accumulator = null;
            boolean first = true;
            for (T r : collection) {
                if (r == null) continue;
                if (first) {
                    first = false;
                    accumulator = r;
                    continue;
                }
                accumulator = this.reduce(accumulator, r);
            }
            return accumulator;
        }

        public T reduce(T var1, T var2);
    }
}

