/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.dataset.CollectionDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segment;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;
import net.e6tech.elements.network.cluster.catalyst.transform.Transform;

public class Series<T, R>
implements Serializable,
Function<Reactor, Collection<R>> {
    private static final long serialVersionUID = 5420350641543073437L;
    protected Segment<T> segment;
    protected List<Transform> transforms = new ArrayList<Transform>();

    public Series() {
    }

    public Series(Series<T, R> other) {
        this.transforms.addAll(other.transforms);
    }

    public static <I, O> Series<I, O> from(Transform<? extends Reactor, I, O> transform) {
        Series t = new Series();
        return t.add(transform);
    }

    @Override
    public Collection<R> apply(Reactor reactor) {
        Stream<Object> stream = this.segment.stream(reactor);
        this.segment = null;
        for (Transform transform : this.transforms) {
            Stream tmp = transform.transform(reactor, stream);
            stream = tmp;
        }
        return stream.collect(Collectors.toList());
    }

    public <U> Series<T, U> add(Transform<? extends Reactor, R, U> transform) {
        this.transforms.add(transform);
        return this;
    }

    public Series<T, R> allocate(Segments<T> segments) {
        Series<T, R> copy = new Series<T, R>();
        copy.segment = segments.remove();
        for (Transform t : this.transforms) {
            Transform p = t.allocate(segments);
            copy.transforms.add(p);
        }
        return copy;
    }

    public DataSet<R> transform(Catalyst<? extends Reactor> catalyst, DataSet<T> dataSet) {
        return new CollectionDataSet(catalyst.transformToList(dataSet, this));
    }
}

