/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Function;
import net.e6tech.elements.network.cluster.catalyst.Catalyst;
import net.e6tech.elements.network.cluster.catalyst.Mapping;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Series;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;

public class Scalar<T, R>
implements Function<Reactor, R>,
Serializable {
    private static final long serialVersionUID = 1676649613567136786L;
    private Series<T, R> series;
    private Mapping<? extends Reactor, Collection<R>, R> mapping;

    public Scalar(Series<T, R> series, Mapping<? extends Reactor, Collection<R>, R> mapping) {
        this.series = series;
        this.mapping = mapping;
    }

    @Override
    public R apply(Reactor reactor) {
        Series<Reactor, R> t = this.series;
        Collection collection = (Collection)t.apply(reactor);
        Mapping<Reactor, Collection<R>, R> m = this.mapping;
        return m.apply(reactor, collection);
    }

    public <S extends Reactor> R scalar(Catalyst<S> catalyst, DataSet<T> dataSet) {
        Mapping<? extends Reactor, Collection<R>, R> m = this.mapping;
        return catalyst.scalar(dataSet, this.series, m);
    }
}

