/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster.catalyst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.network.cluster.ClusterAsync;
import net.e6tech.elements.network.cluster.Registry;
import net.e6tech.elements.network.cluster.catalyst.Mapping;
import net.e6tech.elements.network.cluster.catalyst.Reactor;
import net.e6tech.elements.network.cluster.catalyst.Scalar;
import net.e6tech.elements.network.cluster.catalyst.Series;
import net.e6tech.elements.network.cluster.catalyst.dataset.CollectionDataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.DataSet;
import net.e6tech.elements.network.cluster.catalyst.dataset.Segments;

public class Catalyst<Re extends Reactor> {
    private Registry registry;
    private long waitTime = 20000L;
    private String qualifier = "";
    private Class<Re> reactorClass;

    public Catalyst(String qualifier, Class<Re> reactorClass, Registry registry) {
        this.qualifier = qualifier;
        this.registry = registry;
        this.reactorClass = reactorClass;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public <T, R> R scalar(DataSet<T> dataSet, Series<T, R> series, Mapping<Re, Collection<R>, R> mapping) {
        Collection result = this.collect(dataSet, series, mapping);
        ClusterAsync<Re> async = this.registry.async(this.qualifier, this.reactorClass, this.waitTime);
        Series emptySeries = new Series();
        return (R)async.apply(p -> p.apply(new Scalar(emptySeries.allocate(new CollectionDataSet(result).segment(this)), mapping))).toCompletableFuture().join();
    }

    public <T, R> Collection<R> collect(DataSet<T> dataSet, Series<T, R> series, Mapping<Re, Collection<R>, R> mapping) {
        List workLoad = this.prepareWork(dataSet, segments -> new Scalar(series.allocate((Segments)segments), mapping));
        ArrayList result = new ArrayList();
        for (Work work : workLoad) {
            work.start();
        }
        for (Work work : workLoad) {
            result.add(work.value());
        }
        return result;
    }

    public <T, R> List<R> transformToList(DataSet<T> dataSet, Series<T, R> series) {
        List workLoad = this.prepareWork(dataSet, segments -> series.allocate((Segments)segments));
        for (Work work : workLoad) {
            work.start();
        }
        ArrayList result = new ArrayList();
        for (Work work : workLoad) {
            result.addAll((Collection)work.value());
        }
        return result;
    }

    private <T, O> List<Work<T, O>> prepareWork(DataSet<T> dataSet, Function<Segments<T>, Function<? extends Reactor, O>> work) {
        Segments<T> segments = dataSet.segment(this);
        ArrayList<Work<T, O>> workLoad = new ArrayList<Work<T, O>>();
        for (int i = 0; i < segments.size(); ++i) {
            workLoad.add(new Work(this.registry.async(this.qualifier, this.reactorClass, this.waitTime), segments, work));
        }
        return workLoad;
    }

    private static class Work<T, R> {
        Async<Reactor> async;
        Segments<T> segments;
        CompletableFuture<R> future;
        Function<Segments<T>, Function<? extends Reactor, R>> work;

        Work(Async<Reactor> async, Segments<T> segments, Function<Segments<T>, Function<? extends Reactor, R>> work) {
            this.async = async;
            this.segments = segments;
            this.work = work;
        }

        void start() {
            Function function = this.work.apply(this.segments);
            this.future = this.async.apply(reactor -> reactor.apply(function)).toCompletableFuture();
        }

        R value() {
            try {
                return this.future.join();
            }
            catch (Exception ex) {
                this.start();
                return this.future.join();
            }
        }
    }
}

