/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.common.util.concurrent.Async;
import net.e6tech.elements.network.cluster.Registry;

public class AsyncImpl<U>
implements Async<U> {
    Class<U> interfaceClass;
    Registry registry;
    String qualifier;
    long timeout = 5000L;
    CompletionStage completionStage;
    U proxy;

    public AsyncImpl(Registry registry, String qualifier, Class<U> interfaceClass, long timeout) {
        this.registry = registry;
        this.qualifier = qualifier;
        this.timeout = timeout;
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        this.interfaceClass = interfaceClass;
        this.proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MyHandler());
    }

    public U proxy() {
        return this.proxy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public <R> CompletionStage<R> apply(Function<U, R> function) {
        this.completionStage = null;
        function.apply(this.proxy);
        return this.completionStage;
    }

    public CompletionStage<Void> accept(Consumer<U> consumer) {
        this.completionStage = null;
        consumer.accept(this.proxy);
        return this.completionStage;
    }

    private class MyHandler
    implements InvocationHandler {
        private MyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("hashCode".equals(methodName) && method.getParameterCount() == 0) {
                return AsyncImpl.this.hashCode();
            }
            if ("equals".equals(methodName) && method.getParameterCount() == 1) {
                return AsyncImpl.this.equals(args[0]);
            }
            if ("toString".equals(methodName) && method.getParameterCount() == 0) {
                return AsyncImpl.this.toString();
            }
            Function<Object[], CompletionStage> function = AsyncImpl.this.registry.route(AsyncImpl.this.qualifier, AsyncImpl.this.interfaceClass, method, AsyncImpl.this.timeout);
            AsyncImpl.this.completionStage = function.apply(args);
            return Primitives.defaultValue(method.getReturnType());
        }
    }
}

