/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Status;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import java.util.concurrent.CompletableFuture;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.Registry;

class RegistryEntryActor
extends AbstractActor {
    LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    Cluster cluster = Cluster.get((ActorSystem)this.getContext().system());
    Events.Registration registration;
    ActorRef workPool;

    public RegistryEntryActor(Events.Registration registration, ActorRef workPool) {
        this.registration = registration;
        this.workPool = workPool;
    }

    public void preStart() {
        this.cluster.subscribe(this.getSelf(), new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.UnreachableMember.class});
        this.getContext().actorSelection(this.getSelf().path().root().address() + "/user/" + Registry.getPath()).tell((Object)new Events.Announcement(this.registration), this.getSelf());
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ClusterEvent.MemberUp.class, member -> this.register(member.member())).match(ClusterEvent.CurrentClusterState.class, state -> {
            for (Member member : state.getMembers()) {
                if (!member.status().equals(MemberStatus.up())) continue;
                this.register(member);
            }
        }).match(ClusterEvent.UnreachableMember.class, member -> this.log.info("Member detected as unreachable: {}", (Object)member.member())).match(ClusterEvent.MemberRemoved.class, member -> this.log.info("Member is Removed: {}", (Object)member.member())).match(Events.Invocation.class, message -> {
            ActorRef sender = this.getSender();
            ActorRef self = this.getSelf();
            try {
                if (this.workPool != null && this.registration.timeout() > 0L) {
                    Patterns.ask((ActorRef)this.workPool, () -> {
                        Object ret = this.registration.function().apply(message.arguments());
                        sender.tell((Object)new Events.Response(ret), self);
                    }, (long)this.registration.timeout());
                } else {
                    CompletableFuture.runAsync(() -> {
                        Object ret = this.registration.function().apply(message.arguments());
                        sender.tell((Object)new Events.Response(ret), self);
                    });
                }
            }
            catch (RuntimeException ex) {
                Throwable throwable = ex.getCause();
                if (throwable == null) {
                    throwable = ex;
                }
                sender.tell((Object)new Status.Failure(throwable), self);
            }
        }).build();
    }

    void register(Member member) {
        this.getContext().actorSelection(member.address() + "/user/" + Registry.getPath()).tell((Object)new Events.Announcement(this.registration), this.getSelf());
    }
}

