/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.pattern.Patterns;
import java.io.Serializable;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.MessagingActor;

class Messaging
implements Broadcast {
    private ActorRef messagingRef;
    private String name = "messaging";
    private long timeout = 5000L;

    Messaging() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void start(ActorSystem system) {
        this.messagingRef = system.actorOf(Props.create(MessagingActor.class, MessagingActor::new), this.name);
    }

    public void shutdown() {
        if (this.messagingRef != null) {
            Patterns.ask((ActorRef)this.messagingRef, (Object)PoisonPill.getInstance(), (long)this.timeout);
        }
    }

    public void subscribe(String topic, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messagingRef, (Object)new Events.Subscribe(topic, subscriber), (long)this.timeout);
    }

    public <T extends Serializable> void subscribe(Class<T> topic, Subscriber<T> subscriber) {
        this.subscribe(topic.getName(), subscriber);
    }

    public void unsubscribe(String topic, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messagingRef, (Object)new Events.Unsubscribe(topic, subscriber), (long)this.timeout);
    }

    public void unsubscribe(Class topic, Subscriber subscriber) {
        this.unsubscribe(topic.getName(), subscriber);
    }

    public void publish(String topic, Serializable object) {
        Patterns.ask((ActorRef)this.messagingRef, (Object)new Events.Publish(topic, object), (long)this.timeout);
    }

    public <T extends Serializable> void publish(Class<T> cls, T object) {
        this.publish(cls.getName(), object);
    }

    public void destination(String destination, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messagingRef, (Object)new Events.NewDestination(destination, subscriber), (long)this.timeout);
    }

    public void send(String destination, Serializable object) {
        Patterns.ask((ActorRef)this.messagingRef, (Object)new Events.Send(destination, object), (long)this.timeout);
    }
}

