/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.Status;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.japi.Creator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.DestinationActor;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.SubscriberActor;

class MessagingActor
extends AbstractActor {
    private static final String SUBSCRIBER_PREFIX = "subscriber-";
    private static final String DESTINATION_PREFIX = "destination-";
    ActorRef mediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
    Map<String, Map<Subscriber, ActorRef>> subscribers = new HashMap<String, Map<Subscriber, ActorRef>>();
    Map<String, ActorRef> destinations = new HashMap<String, ActorRef>();

    MessagingActor() {
    }

    public void postStop() {
        for (Map<Subscriber, ActorRef> map : this.subscribers.values()) {
            for (ActorRef ref : map.values()) {
                ref.tell((Object)PoisonPill.getInstance(), this.getSender());
            }
        }
        this.subscribers.clear();
        for (ActorRef ref : this.destinations.values()) {
            ref.tell((Object)PoisonPill.getInstance(), this.getSender());
        }
        this.destinations.clear();
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Events.Subscribe.class, event -> {
            Map map = this.subscribers.computeIfAbsent(event.topic, topic -> new HashMap());
            map.computeIfAbsent(event.subscriber, sub -> this.getContext().actorOf(Props.create(SubscriberActor.class, (Creator & Serializable)() -> new SubscriberActor(event.topic, event.subscriber)), SUBSCRIBER_PREFIX + event.topic + System.identityHashCode(event.subscriber)));
        }).match(Events.Unsubscribe.class, event -> {
            ActorRef child;
            Map<Subscriber, ActorRef> map = this.subscribers.get(event.topic);
            if (map != null && (child = map.get(event.subscriber)) != null) {
                this.mediator.tell((Object)new DistributedPubSubMediator.Unsubscribe(event.topic, child), this.getSelf());
                child.tell((Object)PoisonPill.getInstance(), this.getSender());
                map.remove(event.subscriber);
            }
        }).match(Events.NewDestination.class, event -> {
            if (this.destinations.get(event.destination) != null) {
                this.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")), this.getSender());
            } else {
                ActorRef dest = this.getContext().actorOf(Props.create(DestinationActor.class, (Creator & Serializable)() -> new DestinationActor(event.subscriber)), DESTINATION_PREFIX + event.destination);
                this.destinations.put(event.destination, dest);
            }
        }).match(Events.RemoveDestination.class, event -> {
            ActorRef child = this.destinations.get(event.destination);
            if (child != null) {
                this.mediator.tell((Object)new DistributedPubSubMediator.Remove(child.path().name()), this.getSelf());
                child.tell((Object)PoisonPill.getInstance(), this.getSender());
                this.destinations.remove("/user/" + this.getSelf().path().name() + "/" + DESTINATION_PREFIX + event.destination);
            }
        }).match(Events.Publish.class, publish -> this.mediator.tell((Object)new DistributedPubSubMediator.Publish(publish.topic, publish), this.getSelf())).match(Events.Send.class, send -> this.mediator.tell((Object)new DistributedPubSubMediator.Send("/user/" + this.getSelf().path().name() + "/" + DESTINATION_PREFIX + send.destination, send, true), this.getSender())).build();
    }
}

