/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.japi.Creator;
import akka.pattern.Patterns;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.e6tech.elements.common.actor.pool.WorkerPool;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.util.SystemException;
import net.e6tech.elements.network.cluster.Async;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.RegistrarActor;
import net.e6tech.elements.network.cluster.RouteListener;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class Registry {
    private static String path = "registry";
    public static final String REGISTRY_DISPATCHER = "registry-dispatcher";
    ActorSystem system;
    ActorRef registrar;
    ActorRef workerPool;
    long timeout = 5000L;
    List<RouteListener> listeners = new ArrayList<RouteListener>();

    public static String getPath() {
        return path;
    }

    public static void setPath(String path) {
        Registry.path = path;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    void onRouteRemoved(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onRouteRemoved(path);
            }
        });
    }

    public ActorRef getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ActorRef workerPool) {
        this.workerPool = workerPool;
    }

    public void start(ActorSystem system) {
        this.system = system;
        if (this.workerPool == null) {
            this.workerPool = system.actorOf(Props.create(WorkerPool.class, (Object[])new Object[0]));
        }
        this.registrar = system.actorOf(Props.create(RegistrarActor.class, (Creator & Serializable)() -> new RegistrarActor(this, this.workerPool)), Registry.getPath());
    }

    public void shutdown() {
        Patterns.ask((ActorRef)this.registrar, (Object)PoisonPill.getInstance(), (long)this.timeout);
    }

    public <R> void register(String path, Function<Object[], R> function) {
        Patterns.ask((ActorRef)this.registrar, (Object)new Events.Registration(path, function), (long)this.timeout);
    }

    public <T> void register(String qualifier, Class<T> interfaceClass, T implementation) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        for (Method method : interfaceClass.getMethods()) {
            String methodName = method.getName();
            if ("hashCode".equals(methodName) && method.getParameterCount() == 0 || "equals".equals(methodName) && method.getParameterCount() == 1 || "toString".equals(methodName) && method.getParameterCount() == 0) continue;
            this.register(this.fullyQualify(qualifier, interfaceClass, method), t -> {
                try {
                    return method.invoke(implementation, t);
                }
                catch (IllegalAccessException e) {
                    throw new SystemException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Logger.suppress((Throwable)e);
                    throw new SystemException(e.getCause());
                }
            });
        }
    }

    String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        String normalizedQualifier;
        StringBuilder builder = new StringBuilder();
        String string = normalizedQualifier = qualifier == null ? "" : qualifier.trim();
        if (normalizedQualifier.length() > 0) {
            builder.append(normalizedQualifier);
            builder.append("@");
        }
        builder.append(interfaceClass.getName());
        builder.append("::");
        builder.append(method.getName());
        builder.append("(");
        boolean first = true;
        for (Class<?> param : method.getParameterTypes()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(param.getTypeName());
        }
        builder.append(")");
        return builder.toString();
    }

    public Function<Object[], CompletionStage> route(String qualifier, Class interfaceClass, Method method, long timeout) {
        return this.route(this.fullyQualify(qualifier, interfaceClass, method), timeout);
    }

    public Function<Object[], CompletionStage> route(String path, long timeout) {
        return arguments -> {
            Future future = Patterns.ask((ActorRef)this.registrar, (Object)new Events.Invocation(path, (Object[])arguments), (long)timeout);
            return FutureConverters.toJava((Future)future).thenApplyAsync(ret -> {
                Events.Response response = (Events.Response)ret;
                return response.getValue();
            });
        };
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass) {
        return new Async<T>(this, qualifier, interfaceClass, this.getTimeout());
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass, long timeout) {
        return new Async<T>(this, qualifier, interfaceClass, timeout);
    }
}

