/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.network.cluster.Registry;

public class Async<U> {
    Class<U> interfaceClass;
    Registry registry;
    String qualifier;
    long timeout = 5000L;
    CompletionStage completionStage;
    U proxy;

    public Async(Registry registry, String qualifier, Class<U> interfaceClass, long timeout) {
        this.registry = registry;
        this.qualifier = qualifier;
        this.timeout = timeout;
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        this.interfaceClass = interfaceClass;
        this.proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MyHandler());
    }

    public U proxy() {
        return this.proxy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public <R> CompletionStage<R> apply(Function<U, R> function) {
        this.completionStage = null;
        function.apply(this.proxy);
        return this.completionStage;
    }

    public CompletionStage<Void> accept(Consumer<U> consumer) {
        this.completionStage = null;
        consumer.accept(this.proxy);
        return this.completionStage;
    }

    private class MyHandler
    implements InvocationHandler {
        private MyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0) {
                return Async.this.hashCode();
            }
            if (method.getName().equals("equals") && method.getParameterCount() == 1) {
                return Async.this.equals(args[0]);
            }
            if (method.getName().equals("toString") && method.getParameterCount() == 0) {
                return Async.this.toString();
            }
            Function<Object[], CompletionStage> function = Async.this.registry.route(Async.this.qualifier, Async.this.interfaceClass, method, Async.this.timeout);
            Async.this.completionStage = function.apply(args);
            return Primitives.defaultValue(method.getReturnType());
        }
    }
}

