/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.japi.Creator;
import akka.pattern.Patterns;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import net.e6tech.elements.network.cluster.Async;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.RegistrarActor;
import net.e6tech.elements.network.cluster.RouteListener;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class Registry {
    private static String PATH = "registry";
    ActorSystem system;
    ActorRef registrar;
    List<RouteListener> listeners = new ArrayList<RouteListener>();

    public static String getPath() {
        return PATH;
    }

    public static void setPath(String PATH) {
        Registry.PATH = PATH;
    }

    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    void onRouteRemoved(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onRouteRemoved(path);
            }
        });
    }

    public void start(ActorSystem system) {
        this.system = system;
        this.registrar = system.actorOf(Props.create(RegistrarActor.class, (Creator & Serializable)() -> new RegistrarActor(this)), PATH);
    }

    public void shutdown() {
        Patterns.ask((ActorRef)this.registrar, (Object)PoisonPill.getInstance(), (long)5000L);
    }

    public <T, R> void register(String qualifier, Class<T> messageType, Class<R> returnType, Function<T, R> function) {
        Patterns.ask((ActorRef)this.registrar, (Object)new Events.Registration(qualifier, messageType, returnType, function), (long)5000L);
    }

    public <T> void register(String qualifier, Class<T> interfaceClass, T implementation) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        qualifier = qualifier == null ? "" : qualifier.trim();
        for (Method method : interfaceClass.getMethods()) {
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0 || method.getName().equals("equals") && method.getParameterCount() == 1 || method.getName().equals("toString") && method.getParameterCount() == 0 || method.getParameterCount() != 1) continue;
            this.register(this.fullyQualify(qualifier, interfaceClass, method), method.getParameterTypes()[0], method.getReturnType(), t -> {
                try {
                    return method.invoke(implementation, t);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException();
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            });
        }
    }

    Function route(String qualifier, Class interfaceClass, Method method, long timeout) {
        return this.route(this.fullyQualify(qualifier, interfaceClass, method), method.getParameterTypes()[0], method.getReturnType(), timeout);
    }

    private String fullyQualify(String qualifier, Class interfaceClass, Method method) {
        qualifier = qualifier == null ? "" : qualifier.trim();
        return qualifier + "@" + interfaceClass.getName() + "." + method.getName();
    }

    public <T, R> Function<T, CompletionStage<R>> route(String qualifier, Class<T> messageClass, Class<R> returnType, long timeout) {
        Function<Object, CompletionStage> function = message -> {
            Future future = Patterns.ask((ActorRef)this.registrar, (Object)new Events.Invocation(qualifier, messageClass, message, returnType), (long)timeout);
            return FutureConverters.toJava((Future)future).thenApply(ret -> {
                Events.Response response = (Events.Response)ret;
                return response.getValue();
            });
        };
        return function;
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass, long timeout) {
        return new Async<T>(this, qualifier, interfaceClass, timeout);
    }
}

