/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.cluster.MemberStatus;
import akka.japi.Creator;
import akka.pattern.Patterns;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.resources.Initializable;
import net.e6tech.elements.common.resources.Resources;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.network.cluster.MemberListener;
import net.e6tech.elements.network.cluster.Messaging;
import net.e6tech.elements.network.cluster.Registry;

public class ClusterNode
implements Initializable {
    private String name;
    private String configuration;
    private ActorSystem system;
    private ActorRef membership;
    private Map<Address, Member> members = new HashMap<Address, Member>();
    private Messaging broadcast;
    private Registry registry;
    private List<MemberListener> memberListeners = new ArrayList<MemberListener>();
    private boolean started = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Broadcast getBroadcast() {
        return this.broadcast;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Map<Address, Member> getMembers() {
        return this.members;
    }

    public ClusterNode() {
    }

    public ClusterNode(ActorSystem system) {
        this.system = system;
    }

    public void initialize(Resources resources) {
        Config config = ConfigFactory.parseString((String)this.configuration);
        this.system = ActorSystem.create((String)this.name, (Config)config);
        this.start();
    }

    public ActorSystem getSystem() {
        return this.system;
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (this.membership == null) {
            this.membership = this.system.actorOf(Props.create(Membership.class, (Creator & Serializable)() -> new Membership()));
        }
        if (this.broadcast == null) {
            this.broadcast = new Messaging();
        }
        if (this.registry == null) {
            this.registry = new Registry();
        }
        this.broadcast.start(this.system);
        this.registry.start(this.system);
        this.started = true;
    }

    public void shutdown() {
        Patterns.ask((ActorRef)this.membership, (Object)PoisonPill.getInstance(), (long)5000L);
        this.broadcast.shutdown();
        this.registry.shutdown();
        this.system.terminate();
        this.members.clear();
        this.started = false;
    }

    class Membership
    extends AbstractActor {
        Cluster cluster = Cluster.get((ActorSystem)this.getContext().system());

        Membership() {
        }

        public void preStart() {
            this.cluster.subscribe(this.getSelf(), new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.UnreachableMember.class});
        }

        public void postStop() {
            this.cluster.unsubscribe(this.getSelf());
        }

        public AbstractActor.Receive createReceive() {
            return this.receiveBuilder().match(ClusterEvent.MemberUp.class, member -> {
                ClusterNode.this.members.put(member.member().address(), member.member());
                ClusterNode.this.memberListeners.forEach(listener -> listener.memberUp(member.member().address().toString()));
            }).match(ClusterEvent.CurrentClusterState.class, state -> {
                for (Member member : state.getMembers()) {
                    if (!member.status().equals(MemberStatus.up())) continue;
                    ClusterNode.this.members.put(member.address(), member);
                    ClusterNode.this.memberListeners.forEach(listener -> listener.memberUp(member.address().toString()));
                }
            }).match(ClusterEvent.UnreachableMember.class, member -> {
                ClusterNode.this.members.remove(member.member().address());
                ClusterNode.this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
            }).match(ClusterEvent.MemberRemoved.class, member -> {
                ClusterNode.this.members.remove(member.member().address());
                ClusterNode.this.memberListeners.forEach(listener -> listener.memberDown(member.member().address().toString()));
            }).build();
        }
    }
}

