/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.NotSupportedException;
import net.e6tech.elements.common.reflection.Primitives;
import net.e6tech.elements.network.cluster.Registry;

public class Async<U> {
    Class<U> interfaceClass;
    Registry registry;
    String qualifier;
    long timeout = 5000L;
    CompletionStage completionStage;
    U proxy;

    public Async(Registry registry, String qualifier, Class<U> interfaceClass, long timeout) {
        this.registry = registry;
        this.qualifier = qualifier;
        this.timeout = timeout;
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        this.interfaceClass = interfaceClass;
        this.proxy = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new MyHandler());
    }

    public U proxy() {
        return this.proxy;
    }

    public <T, R> CompletionStage<R> apply(Function<U, Function<T, R>> function, T argument) {
        this.completionStage = null;
        Function<T, R> function2 = function.apply(this.proxy);
        function2.apply(argument);
        return this.completionStage;
    }

    public <T, R> CompletionStage<R> accept(Function<U, Consumer<T>> function, T argument) {
        this.completionStage = null;
        Consumer<T> consumer = function.apply(this.proxy);
        consumer.accept(argument);
        return this.completionStage;
    }

    private class MyHandler
    implements InvocationHandler {
        private MyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0) {
                return Async.this.hashCode();
            }
            if (method.getName().equals("equals") && method.getParameterCount() == 1) {
                return Async.this.equals(args[0]);
            }
            if (method.getName().equals("toString") && method.getParameterCount() == 0) {
                return Async.this.toString();
            }
            if (method.getParameterCount() == 1) {
                Function function = Async.this.registry.route(Async.this.qualifier, Async.this.interfaceClass, method, Async.this.timeout);
                Async.this.completionStage = (CompletionStage)function.apply(args[0]);
                return Primitives.defaultValue(method.getReturnType());
            }
            throw new NotSupportedException();
        }
    }
}

