/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import net.e6tech.elements.common.subscribe.Notice;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.Events;

public class SubscriberActor
extends AbstractActor {
    LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Subscriber subscriber;

    public SubscriberActor(String topic, Subscriber subscriber) {
        this.subscriber = subscriber;
        ActorRef mediator = DistributedPubSub.get((ActorSystem)this.getContext().system()).mediator();
        mediator.tell((Object)new DistributedPubSubMediator.Subscribe(topic, this.getSelf()), this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Events.Publish.class, publish -> CompletableFuture.runAsync(() -> this.subscriber.receive(new Notice(publish.topic, (Serializable)publish.message)))).match(DistributedPubSubMediator.SubscribeAck.class, msg -> this.log.info("subscribing")).build();
    }
}

