/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.japi.Creator;
import akka.pattern.Patterns;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.inject.Inject;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.network.cluster.Async;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.RegistrarActor;
import net.e6tech.elements.network.cluster.Response;
import net.e6tech.elements.network.cluster.RouteListener;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class Registry
implements Startable {
    private static String PATH = "registry";
    @Inject
    ActorSystem system;
    ActorRef registrar;
    List<RouteListener> listeners = new ArrayList<RouteListener>();

    public static String getPath() {
        return PATH;
    }

    public static void setPath(String PATH) {
        Registry.PATH = PATH;
    }

    public Registry() {
    }

    public Registry(ActorSystem system) {
        this.system = system;
    }

    public void addRouteListener(RouteListener listener) {
        this.listeners.add(listener);
    }

    public void removeRouteListener(RouteListener listener) {
        this.listeners.remove(listener);
    }

    void onAnnouncement(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onAnnouncement(path);
            }
        });
    }

    void onTerminated(String path, ActorRef actor) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onTerminated(path, actor.path().toString());
            }
        });
    }

    void onRouteRemoved(String path) {
        this.system.dispatcher().execute(() -> {
            for (RouteListener l : this.listeners) {
                l.onRouteRemoved(path);
            }
        });
    }

    public void start() {
        this.registrar = this.system.actorOf(Props.create(RegistrarActor.class, (Creator & Serializable)() -> new RegistrarActor(this)), PATH);
    }

    public <T, R> void register(String qualifier, Class<T> messageType, Class<R> returnType, Function<T, R> function) {
        Patterns.ask((ActorRef)this.registrar, (Object)new Events.Registration(qualifier, messageType, returnType, function), (long)5000L);
    }

    public <T> void register(String qualifier, Class<T> interfaceClass, T implementation) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("interfaceClass needs to be an interface");
        }
        HashMap callTypes = new HashMap();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : interfaceClass.getMethods()) {
            if (method.getName().equals("hashCode") && method.getParameterCount() == 0 || method.getName().equals("equals") && method.getParameterCount() == 1 || method.getName().equals("toString") && method.getParameterCount() == 0 || method.getParameterCount() != 1) continue;
            Class<?> paramType = method.getParameterTypes()[0];
            if (callTypes.get(paramType) != null && ((Method)callTypes.get(paramType)).getReturnType().equals(method.getReturnType())) {
                throw new IllegalArgumentException("Methods have the same argument and return type: " + ((Method)callTypes.get(paramType)).getName() + ", " + method.getName());
            }
            callTypes.put(paramType, method);
            methods.add(method);
        }
        for (Method method : methods) {
            this.register(qualifier, method.getParameterTypes()[0], method.getReturnType(), t -> {
                try {
                    return method.invoke(implementation, t);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException();
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                }
            });
        }
    }

    public <T extends Serializable, R> Function<T, CompletionStage<R>> route(String qualifier, Class<T> messageClass, Class<R> returnType, long timeout) {
        Function<Serializable, CompletionStage> function = message -> {
            Future future = Patterns.ask((ActorRef)this.registrar, (Object)new Events.Invocation(qualifier, messageClass, message, returnType), (long)timeout);
            return FutureConverters.toJava((Future)future).thenApply(ret -> {
                Response response = (Response)ret;
                return response.getValue();
            });
        };
        return function;
    }

    public <T> Async<T> async(String qualifier, Class<T> interfaceClass, long timeout) {
        return new Async<T>(this, qualifier, interfaceClass, timeout);
    }
}

