/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Status;
import akka.actor.Terminated;
import akka.cluster.Cluster;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.japi.Creator;
import akka.routing.RoundRobinRoutingLogic;
import akka.routing.Router;
import akka.routing.RoutingLogic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.e6tech.elements.common.resources.NotAvailableException;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.RegisterEntryActor;
import net.e6tech.elements.network.cluster.Registry;

public class RegistrarActor
extends AbstractActor {
    private LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Cluster cluster = Cluster.get((ActorSystem)this.getContext().system());
    private Map<String, Router> services = new HashMap<String, Router>();
    private Map<ActorRef, List<String>> actors = new HashMap<ActorRef, List<String>>();
    private Registry registry;

    public RegistrarActor(Registry registry) {
        this.registry = registry;
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(Events.Registration.class, message -> {
            ActorRef entry = this.getContext().actorOf(Props.create(RegisterEntryActor.class, (Creator & Serializable)() -> new RegisterEntryActor((Events.Registration)message)));
        }).match(Events.Announcement.class, message -> {
            this.getContext().watch(this.getSender());
            Router router = this.services.computeIfAbsent(message.path(), cls -> new Router((RoutingLogic)new RoundRobinRoutingLogic()));
            router = router.addRoutee(this.getSender());
            this.services.put(message.path(), router);
            List paths = this.actors.computeIfAbsent(this.getSender(), ref -> new ArrayList());
            paths.add(message.path());
            this.registry.onAnnouncement(message.path());
        }).match(Terminated.class, terminated -> {
            ActorRef actor = terminated.getActor();
            List<String> paths = this.actors.get(actor);
            if (paths != null) {
                for (String path : paths) {
                    Router router = this.services.get(path);
                    if (router == null) continue;
                    this.registry.onTerminated(path, actor);
                    router = router.removeRoutee(this.getSender());
                    this.services.put(path, router);
                    if (router.routees().length() != 0) continue;
                    this.registry.onRouteRemoved(path);
                }
                this.actors.remove(actor);
            }
        }).match(Events.Invocation.class, invocation -> {
            Router router = this.services.get(invocation.path());
            if (router == null || router.routees().length() == 0) {
                this.getSender().tell((Object)new Status.Failure((Throwable)new NotAvailableException("Service not available.")), this.getSelf());
            } else {
                router.route(invocation, this.getSender());
            }
        }).build();
    }
}

