/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.cluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.japi.Creator;
import akka.pattern.Patterns;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.common.subscribe.Broadcast;
import net.e6tech.elements.common.subscribe.Subscriber;
import net.e6tech.elements.network.cluster.Events;
import net.e6tech.elements.network.cluster.MessagingActor;

public class Messaging
implements Broadcast,
Startable {
    @Inject
    ActorSystem system;
    ActorRef messaging;
    String name = "messaging";
    Map<String, Map<Subscriber, ActorRef>> subscribers = new HashMap<String, Map<Subscriber, ActorRef>>();

    public Messaging() {
    }

    public Messaging(ActorSystem system) {
        this.system = system;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.messaging = this.system.actorOf(Props.create(MessagingActor.class, (Creator & Serializable)() -> new MessagingActor()), this.name);
    }

    public void shutdown() {
        if (this.messaging != null) {
            Patterns.ask((ActorRef)this.messaging, (Object)PoisonPill.getInstance(), (long)5000L);
        }
    }

    public void subscribe(String topic, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messaging, (Object)new Events.Subscribe(topic, subscriber), (long)5000L);
    }

    public <T extends Serializable> void subscribe(Class<T> topic, Subscriber<T> subscriber) {
        this.subscribe(topic.getName(), subscriber);
    }

    public void unsubscribe(String topic, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messaging, (Object)new Events.Unsubscribe(topic, subscriber), (long)5000L);
    }

    public void unsubscribe(Class topic, Subscriber subscriber) {
        this.unsubscribe(topic.getName(), subscriber);
    }

    public void publish(String topic, Serializable object) {
        Patterns.ask((ActorRef)this.messaging, (Object)new Events.Publish(topic, object), (long)5000L);
    }

    public <T extends Serializable> void publish(Class<T> cls, T object) {
        this.publish(cls.getName(), object);
    }

    public void destination(String destination, Subscriber subscriber) {
        Patterns.ask((ActorRef)this.messaging, (Object)new Events.NewDestination(destination, subscriber), (long)5000L);
    }

    public void send(String destination, Serializable object) {
        Patterns.ask((ActorRef)this.messaging, (Object)new Events.Send(destination, object), (long)5000L);
    }
}

