/*
 * Decompiled with CFR 0.152.
 */
package net.e6tech.elements.network.proxy;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.e6tech.elements.common.logging.Logger;
import net.e6tech.elements.common.notification.NotificationCenter;
import net.e6tech.elements.common.resources.Startable;
import net.e6tech.elements.network.clustering.Cluster;
import net.e6tech.elements.network.clustering.ClusterService;
import net.e6tech.elements.network.proxy.Transfer;

public class ClusterSocketProxyServer
implements Startable,
Runnable {
    private static Logger logger = Logger.getLogger();
    @Inject
    private NotificationCenter notificationCenter;
    private int port;
    private int servicePort;
    private ServerSocket serverSocket;
    private ExecutorService threadPool;
    private String serviceName;
    private Cluster cluster;
    private ClusterService service = new ClusterService();

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void start() {
        if (this.threadPool == null) {
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            this.threadPool = Executors.newCachedThreadPool(runnable -> {
                Thread thread = new Thread(group, runnable, "ClusterSocketProxyServer");
                thread.setName("ClusterSocketProxyServer-" + thread.getId());
                thread.setDaemon(true);
                return thread;
            });
        }
        this.service.setName(this.serviceName);
        this.service.setPort(this.servicePort);
        this.cluster.addClusterService(this.service);
        this.threadPool.execute(this);
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            while (true) {
                try {
                    while (true) {
                        Transfer transfer = this.getTransfer();
                        this.threadPool.execute(transfer);
                    }
                }
                catch (IOException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            throw logger.runtimeException(th);
        }
    }

    protected Transfer getTransfer() throws IOException {
        Socket socket = this.serverSocket.accept();
        ClusterService service = this.cluster.getClusterService(this.serviceName);
        if (service == null) {
            throw new RuntimeException("Service not found: " + this.serviceName);
        }
        InetAddress inetAddress = service.getMember().getAddresses()[0];
        int port = service.getPort();
        Transfer transfer = new Transfer(inetAddress.getHostAddress(), port, socket, this.threadPool);
        return transfer;
    }
}

